/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ConditionalEventDefinition;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.IntermediateCatchEvent;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ProcessLevelValidator;

public class IntermediateCatchEventValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List intermediateCatchEvents = process.findFlowElementsOfType(IntermediateCatchEvent.class);
        for (IntermediateCatchEvent intermediateCatchEvent : intermediateCatchEvents) {
            EventDefinition eventDefinition = null;
            if (!intermediateCatchEvent.getEventDefinitions().isEmpty()) {
                eventDefinition = (EventDefinition)intermediateCatchEvent.getEventDefinitions().get(0);
            }
            if (eventDefinition == null) {
                List eventTypeExtensionElements;
                Map extensionElements = intermediateCatchEvent.getExtensionElements();
                if (!extensionElements.isEmpty() && (eventTypeExtensionElements = (List)intermediateCatchEvent.getExtensionElements().get("eventType")) != null && !eventTypeExtensionElements.isEmpty()) {
                    return;
                }
                this.addError(errors, "flowable-intermediate-catch-event-no-eventdefinition", process, (BaseElement)intermediateCatchEvent, "No event definition for intermediate catch event ");
                continue;
            }
            if (eventDefinition instanceof TimerEventDefinition || eventDefinition instanceof SignalEventDefinition || eventDefinition instanceof MessageEventDefinition || eventDefinition instanceof ConditionalEventDefinition) continue;
            this.addError(errors, "flowable-intermediate-catch-event-invalid-eventdefinition", process, (BaseElement)intermediateCatchEvent, "Unsupported intermediate catch event type");
        }
    }
}

