/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.List;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowableListener;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.UserTask;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ProcessLevelValidator;

public class UserTaskValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List userTasks = process.findFlowElementsOfType(UserTask.class);
        for (UserTask userTask : userTasks) {
            if (userTask.getTaskListeners() == null) continue;
            for (FlowableListener listener : userTask.getTaskListeners()) {
                if (listener.getImplementation() != null && listener.getImplementationType() != null) continue;
                this.addError(errors, "flowable-usertask-listener-implementation-missing", process, (BaseElement)userTask, "Element 'class' or 'expression' is mandatory on executionListener");
            }
        }
    }
}

