/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.osgi;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BpmnTransformer {
    static DocumentBuilderFactory dbf;
    static TransformerFactory tf;
    private static final String DEFAULT_VERSION = "0.0.0";
    private static final Pattern ARTIFACT_MATCHER;
    private static final Pattern FUZZY_MODIFIDER;

    public static void transform(URL url, OutputStream os) throws Exception {
        Object e;
        Document doc = BpmnTransformer.parse(url);
        String name = url.getPath();
        int idx = name.lastIndexOf(47);
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        String[] str = BpmnTransformer.extractNameVersionType(name);
        Manifest m = new Manifest();
        m.getMainAttributes().putValue("Manifest-Version", "2");
        m.getMainAttributes().putValue("Bundle-ManifestVersion", "2");
        m.getMainAttributes().putValue("Bundle-SymbolicName", str[0]);
        m.getMainAttributes().putValue("Bundle-Version", str[1]);
        m.getMainAttributes().putValue("Flowable-Bundle", "OSGI-INF/flowable/");
        NodeList l = doc.getElementsByTagName("manifest");
        if (l != null) {
            for (int i = 0; i < l.getLength(); ++i) {
                e = (Element)l.item(i);
                String text = e.getTextContent();
                Properties props = new Properties();
                props.load(new ByteArrayInputStream(text.trim().getBytes()));
                Enumeration<?> en = props.propertyNames();
                while (en.hasMoreElements()) {
                    String k = (String)en.nextElement();
                    String v = props.getProperty(k);
                    m.getMainAttributes().putValue(k, v);
                }
                e.getParentNode().removeChild((Node)e);
            }
        }
        JarOutputStream out = new JarOutputStream(os);
        e = new ZipEntry("META-INF/MANIFEST.MF");
        out.putNextEntry((ZipEntry)e);
        m.write(out);
        out.closeEntry();
        e = new ZipEntry("OSGI-INF/");
        out.putNextEntry((ZipEntry)e);
        e = new ZipEntry("OSGI-INF/flowable/");
        out.putNextEntry((ZipEntry)e);
        out.closeEntry();
        e = new ZipEntry("OSGI-INF/flowable/" + name);
        out.putNextEntry((ZipEntry)e);
        if (tf == null) {
            tf = TransformerFactory.newInstance();
        }
        tf.newTransformer().transform(new DOMSource(doc), new StreamResult(out));
        out.closeEntry();
        out.close();
    }

    public static String[] extractNameVersionType(String url) {
        Matcher m = ARTIFACT_MATCHER.matcher(url);
        if (!m.matches()) {
            return new String[]{url, DEFAULT_VERSION};
        }
        StringBuffer v = new StringBuffer();
        String d1 = m.group(1);
        String d2 = m.group(2);
        String d3 = m.group(3);
        String d4 = m.group(4);
        String d5 = m.group(5);
        String d6 = m.group(6);
        if (d2 != null) {
            v.append(d2);
            if (d3 != null) {
                v.append('.');
                v.append(d3);
                if (d4 != null) {
                    v.append('.');
                    v.append(d4);
                    if (d5 != null) {
                        v.append(".");
                        BpmnTransformer.cleanupModifier(v, d5);
                    }
                } else if (d5 != null) {
                    v.append(".0.");
                    BpmnTransformer.cleanupModifier(v, d5);
                }
            } else if (d5 != null) {
                v.append(".0.0.");
                BpmnTransformer.cleanupModifier(v, d5);
            }
        }
        return new String[]{d1, v.toString(), d6};
    }

    private static void cleanupModifier(StringBuffer result, String modifier) {
        Matcher m = FUZZY_MODIFIDER.matcher(modifier);
        if (m.matches()) {
            modifier = m.group(1);
        }
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') && c != '-') continue;
            result.append(c);
        }
    }

    protected static Document parse(URL url) throws Exception {
        if (dbf == null) {
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
        }
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(url.toString());
    }

    protected static void copyInputStream(InputStream in, OutputStream out) throws Exception {
        byte[] buffer = new byte[4096];
        int len = in.read(buffer);
        while (len >= 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
    }

    static {
        ARTIFACT_MATCHER = Pattern.compile("(.+)(?:-(\\d+)(?:\\.(\\d+)(?:\\.(\\d+))?)?(?:[^a-zA-Z0-9](.*))?)(?:\\.([^\\.]+))", 32);
        FUZZY_MODIFIDER = Pattern.compile("(?:\\d+[.-])*(.*)", 32);
    }
}

