/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.osgi;

import java.io.File;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BpmnDeploymentListener
implements ArtifactUrlTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BpmnDeploymentListener.class);
    private DocumentBuilderFactory dbf;

    public boolean canHandle(File artifact) {
        try {
            if (artifact.isFile() && artifact.getName().endsWith(".xml")) {
                Document doc = this.parse(artifact);
                String name = doc.getDocumentElement().getLocalName();
                String uri = doc.getDocumentElement().getNamespaceURI();
                if ("definitions".equals(name) && "http://www.omg.org/spec/BPMN/20100524/MODEL".equals(uri)) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to parse deployed file {}", (Object)artifact.getAbsolutePath(), (Object)e);
        }
        return false;
    }

    public URL transform(URL artifact) {
        try {
            return new URL("bpmn", null, artifact.toString());
        }
        catch (Exception e) {
            LOGGER.error("Unable to build BPMN bundle", (Throwable)e);
            return null;
        }
    }

    protected Document parse(File artifact) throws Exception {
        if (this.dbf == null) {
            this.dbf = DocumentBuilderFactory.newInstance();
            this.dbf.setNamespaceAware(true);
        }
        DocumentBuilder db = this.dbf.newDocumentBuilder();
        db.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }
        });
        return db.parse(artifact);
    }
}

