/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ldap;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.GroupQuery;
import org.flowable.idm.api.NativeGroupQuery;
import org.flowable.idm.api.NativeUserQuery;
import org.flowable.idm.api.PrivilegeMapping;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.impl.IdmIdentityServiceImpl;
import org.flowable.idm.engine.impl.persistence.entity.GroupEntityImpl;
import org.flowable.idm.engine.impl.persistence.entity.UserEntityImpl;
import org.flowable.ldap.LDAPCallBack;
import org.flowable.ldap.LDAPConfiguration;
import org.flowable.ldap.LDAPConnectionUtil;
import org.flowable.ldap.LDAPGroupCache;
import org.flowable.ldap.LDAPTemplate;
import org.flowable.ldap.impl.LDAPGroupQueryImpl;
import org.flowable.ldap.impl.LDAPUserQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPIdentityServiceImpl
extends IdmIdentityServiceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(LDAPIdentityServiceImpl.class);
    protected LDAPConfiguration ldapConfigurator;
    protected LDAPGroupCache ldapGroupCache;

    public LDAPIdentityServiceImpl(LDAPConfiguration ldapConfigurator, LDAPGroupCache ldapGroupCache, IdmEngineConfiguration idmEngineConfiguration) {
        super(idmEngineConfiguration);
        this.ldapConfigurator = ldapConfigurator;
        this.ldapGroupCache = ldapGroupCache;
    }

    public UserQuery createUserQuery() {
        return new LDAPUserQueryImpl(this.ldapConfigurator);
    }

    public GroupQuery createGroupQuery() {
        return new LDAPGroupQueryImpl(this.ldapConfigurator, this.ldapGroupCache);
    }

    public boolean checkPassword(String userId, String password) {
        return this.executeCheckPassword(userId, password);
    }

    public List<Group> getGroupsWithPrivilege(String name) {
        ArrayList<Group> groups = new ArrayList<Group>();
        List privilegeMappings = this.getPrivilegeMappingsByPrivilegeId(name);
        for (PrivilegeMapping privilegeMapping : privilegeMappings) {
            if (privilegeMapping.getGroupId() == null) continue;
            GroupEntityImpl group = new GroupEntityImpl();
            group.setId(privilegeMapping.getGroupId());
            group.setName(privilegeMapping.getGroupId());
            groups.add((Group)group);
        }
        return groups;
    }

    public List<User> getUsersWithPrivilege(String name) {
        ArrayList<User> users = new ArrayList<User>();
        List privilegeMappings = this.getPrivilegeMappingsByPrivilegeId(name);
        for (PrivilegeMapping privilegeMapping : privilegeMappings) {
            if (privilegeMapping.getUserId() == null) continue;
            UserEntityImpl user = new UserEntityImpl();
            user.setId(privilegeMapping.getUserId());
            user.setLastName(privilegeMapping.getUserId());
            users.add((User)user);
        }
        return users;
    }

    public User newUser(String userId) {
        throw new FlowableException("LDAP identity service doesn't support creating a new user");
    }

    public void saveUser(User user) {
        throw new FlowableException("LDAP identity service doesn't support saving an user");
    }

    public NativeUserQuery createNativeUserQuery() {
        throw new FlowableException("LDAP identity service doesn't support native querying");
    }

    public void deleteUser(String userId) {
        throw new FlowableException("LDAP identity service doesn't support deleting an user");
    }

    public Group newGroup(String groupId) {
        throw new FlowableException("LDAP identity service doesn't support creating a new group");
    }

    public NativeGroupQuery createNativeGroupQuery() {
        throw new FlowableException("LDAP identity service doesn't support native querying");
    }

    public void saveGroup(Group group) {
        throw new FlowableException("LDAP identity service doesn't support saving a group");
    }

    public void deleteGroup(String groupId) {
        throw new FlowableException("LDAP identity service doesn't support deleting a group");
    }

    protected boolean executeCheckPassword(final String userId, final String password) {
        if (password == null || password.length() == 0) {
            throw new FlowableException("Null or empty passwords are not allowed!");
        }
        try {
            LDAPTemplate ldapTemplate = new LDAPTemplate(this.ldapConfigurator);
            return ldapTemplate.execute(new LDAPCallBack<Boolean>(){

                @Override
                public Boolean executeInContext(InitialDirContext initialDirContext) {
                    if (initialDirContext == null) {
                        return false;
                    }
                    String userDn = null;
                    try {
                        String searchExpression = LDAPIdentityServiceImpl.this.ldapConfigurator.getLdapQueryBuilder().buildQueryByUserId(LDAPIdentityServiceImpl.this.ldapConfigurator, userId);
                        String baseDn = LDAPIdentityServiceImpl.this.ldapConfigurator.getUserBaseDn() != null ? LDAPIdentityServiceImpl.this.ldapConfigurator.getUserBaseDn() : LDAPIdentityServiceImpl.this.ldapConfigurator.getBaseDn();
                        NamingEnumeration<SearchResult> namingEnum = initialDirContext.search(baseDn, searchExpression, LDAPIdentityServiceImpl.this.createSearchControls());
                        while (namingEnum.hasMore()) {
                            SearchResult result = namingEnum.next();
                            userDn = result.getNameInNamespace();
                        }
                        namingEnum.close();
                    }
                    catch (NamingException ne) {
                        LOGGER.info("Could not authenticate user {} : {}", new Object[]{userId, ne.getMessage(), ne});
                        return false;
                    }
                    if (userDn != null) {
                        InitialDirContext verificationContext = null;
                        try {
                            verificationContext = LDAPConnectionUtil.createDirectoryContext(LDAPIdentityServiceImpl.this.ldapConfigurator, userDn, password);
                        }
                        catch (FlowableException flowableException) {
                            // empty catch block
                        }
                        if (verificationContext != null) {
                            LDAPConnectionUtil.closeDirectoryContext(verificationContext);
                            return true;
                        }
                    }
                    return false;
                }
            });
        }
        catch (FlowableException e) {
            LOGGER.info("Could not authenticate user : {}", (Object)userId, (Object)e);
            return false;
        }
    }

    protected SearchControls createSearchControls() {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setTimeLimit(this.ldapConfigurator.getSearchTimeLimit());
        return searchControls;
    }

    public LDAPGroupCache getLdapGroupCache() {
        return this.ldapGroupCache;
    }

    public void setLdapGroupCache(LDAPGroupCache ldapGroupCache) {
        this.ldapGroupCache = ldapGroupCache;
    }
}

