/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.ReceiveTask;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterContext;
import org.flowable.editor.language.json.converter.BpmnJsonConverterUtil;

public class ReceiveTaskJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        ReceiveTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        ReceiveTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("ReceiveTask", ReceiveTaskJsonConverter.class);
        convertersToBpmnMap.put("ReceiveEventTask", ReceiveTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(ReceiveTask.class, ReceiveTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        String eventType;
        if (baseElement.getExtensionElements().get("eventType") != null && ((List)baseElement.getExtensionElements().get("eventType")).size() > 0 && StringUtils.isNotEmpty((CharSequence)(eventType = ((ExtensionElement)((List)baseElement.getExtensionElements().get("eventType")).get(0)).getElementText()))) {
            return "ReceiveEventTask";
        }
        return "ReceiveTask";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement, BpmnJsonConverterContext converterContext) {
        this.addEventRegistryProperties((FlowElement)baseElement, propertiesNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BpmnJsonConverterContext converterContext) {
        ReceiveTask task = new ReceiveTask();
        String stencilId = BpmnJsonConverterUtil.getStencilId(elementNode);
        if ("ReceiveEventTask".equals(stencilId)) {
            this.addReceiveEventExtensionElements(elementNode, (FlowElement)task);
        }
        return task;
    }
}

