/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl;

import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.query.QueryCacheValues;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.query.AbstractQuery;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.GroupQuery;
import org.flowable.idm.api.GroupQueryProperty;
import org.flowable.idm.engine.impl.util.CommandContextUtil;

public class GroupQueryImpl
extends AbstractQuery<GroupQuery, Group>
implements GroupQuery,
QueryCacheValues {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected List<String> ids;
    protected String name;
    protected String nameLike;
    protected String nameLikeIgnoreCase;
    protected String type;
    protected String userId;
    protected List<String> userIds;

    public GroupQueryImpl() {
    }

    public GroupQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public GroupQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public GroupQuery groupId(String id) {
        if (id == null) {
            throw new FlowableIllegalArgumentException("Provided id is null");
        }
        this.id = id;
        return this;
    }

    public GroupQuery groupIds(List<String> ids) {
        if (ids == null) {
            throw new FlowableIllegalArgumentException("Provided id list is null");
        }
        this.ids = ids;
        return this;
    }

    public GroupQuery groupName(String name) {
        if (name == null) {
            throw new FlowableIllegalArgumentException("Provided name is null");
        }
        this.name = name;
        return this;
    }

    public GroupQuery groupNameLike(String nameLike) {
        if (nameLike == null) {
            throw new FlowableIllegalArgumentException("Provided name is null");
        }
        this.nameLike = nameLike;
        return this;
    }

    public GroupQuery groupNameLikeIgnoreCase(String nameLikeIgnoreCase) {
        if (nameLikeIgnoreCase == null) {
            throw new FlowableIllegalArgumentException("Provided name is null");
        }
        this.nameLikeIgnoreCase = nameLikeIgnoreCase.toLowerCase();
        return this;
    }

    public GroupQuery groupType(String type) {
        if (type == null) {
            throw new FlowableIllegalArgumentException("Provided type is null");
        }
        this.type = type;
        return this;
    }

    public GroupQuery groupMember(String userId) {
        if (userId == null) {
            throw new FlowableIllegalArgumentException("Provided userId is null");
        }
        this.userId = userId;
        return this;
    }

    public GroupQuery groupMembers(List<String> userIds) {
        if (userIds == null) {
            throw new FlowableIllegalArgumentException("Provided userIds is null");
        }
        this.userIds = userIds;
        return this;
    }

    public GroupQuery orderByGroupId() {
        return (GroupQuery)this.orderBy((QueryProperty)GroupQueryProperty.GROUP_ID);
    }

    public GroupQuery orderByGroupName() {
        return (GroupQuery)this.orderBy((QueryProperty)GroupQueryProperty.NAME);
    }

    public GroupQuery orderByGroupType() {
        return (GroupQuery)this.orderBy((QueryProperty)GroupQueryProperty.TYPE);
    }

    public long executeCount(CommandContext commandContext) {
        return CommandContextUtil.getGroupEntityManager(commandContext).findGroupCountByQueryCriteria(this);
    }

    public List<Group> executeList(CommandContext commandContext) {
        return CommandContextUtil.getGroupEntityManager(commandContext).findGroupByQueryCriteria(this);
    }

    public String getId() {
        return this.id;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getNameLikeIgnoreCase() {
        return this.nameLikeIgnoreCase;
    }

    public String getType() {
        return this.type;
    }

    public String getUserId() {
        return this.userId;
    }

    public List<String> getUserIds() {
        return this.userIds;
    }
}

