/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl;

import java.util.List;
import org.flowable.engine.common.impl.identity.Authentication;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.GroupQuery;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.api.NativeGroupQuery;
import org.flowable.idm.api.NativeTokenQuery;
import org.flowable.idm.api.NativeUserQuery;
import org.flowable.idm.api.Picture;
import org.flowable.idm.api.Privilege;
import org.flowable.idm.api.PrivilegeMapping;
import org.flowable.idm.api.PrivilegeQuery;
import org.flowable.idm.api.Token;
import org.flowable.idm.api.TokenQuery;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.idm.engine.impl.NativeGroupQueryImpl;
import org.flowable.idm.engine.impl.NativeTokenQueryImpl;
import org.flowable.idm.engine.impl.NativeUserQueryImpl;
import org.flowable.idm.engine.impl.ServiceImpl;
import org.flowable.idm.engine.impl.cmd.AddPrivilegeMappingCmd;
import org.flowable.idm.engine.impl.cmd.CheckPassword;
import org.flowable.idm.engine.impl.cmd.CreateGroupCmd;
import org.flowable.idm.engine.impl.cmd.CreateGroupQueryCmd;
import org.flowable.idm.engine.impl.cmd.CreateMembershipCmd;
import org.flowable.idm.engine.impl.cmd.CreatePrivilegeCmd;
import org.flowable.idm.engine.impl.cmd.CreatePrivilegeQueryCmd;
import org.flowable.idm.engine.impl.cmd.CreateTokenCmd;
import org.flowable.idm.engine.impl.cmd.CreateTokenQueryCmd;
import org.flowable.idm.engine.impl.cmd.CreateUserCmd;
import org.flowable.idm.engine.impl.cmd.CreateUserQueryCmd;
import org.flowable.idm.engine.impl.cmd.DeleteGroupCmd;
import org.flowable.idm.engine.impl.cmd.DeleteMembershipCmd;
import org.flowable.idm.engine.impl.cmd.DeletePrivilegeCmd;
import org.flowable.idm.engine.impl.cmd.DeletePrivilegeMappingCmd;
import org.flowable.idm.engine.impl.cmd.DeleteTokenCmd;
import org.flowable.idm.engine.impl.cmd.DeleteUserCmd;
import org.flowable.idm.engine.impl.cmd.DeleteUserInfoCmd;
import org.flowable.idm.engine.impl.cmd.GetGroupsWithPrivilegeCmd;
import org.flowable.idm.engine.impl.cmd.GetPrivilegeMappingsByPrivilegeIdCmd;
import org.flowable.idm.engine.impl.cmd.GetUserInfoCmd;
import org.flowable.idm.engine.impl.cmd.GetUserInfoKeysCmd;
import org.flowable.idm.engine.impl.cmd.GetUserPictureCmd;
import org.flowable.idm.engine.impl.cmd.GetUsersWithPrivilegeCmd;
import org.flowable.idm.engine.impl.cmd.SaveGroupCmd;
import org.flowable.idm.engine.impl.cmd.SaveTokenCmd;
import org.flowable.idm.engine.impl.cmd.SaveUserCmd;
import org.flowable.idm.engine.impl.cmd.SetUserInfoCmd;
import org.flowable.idm.engine.impl.cmd.SetUserPictureCmd;
import org.flowable.idm.engine.impl.cmd.UpdateUserPasswordCmd;

public class IdmIdentityServiceImpl
extends ServiceImpl
implements IdmIdentityService {
    public Group newGroup(String groupId) {
        return (Group)this.commandExecutor.execute((Command)new CreateGroupCmd(groupId));
    }

    public User newUser(String userId) {
        return (User)this.commandExecutor.execute((Command)new CreateUserCmd(userId));
    }

    public void saveGroup(Group group) {
        this.commandExecutor.execute((Command)new SaveGroupCmd(group));
    }

    public void saveUser(User user) {
        this.commandExecutor.execute((Command)new SaveUserCmd(user));
    }

    public void updateUserPassword(User user) {
        this.commandExecutor.execute((Command)new UpdateUserPasswordCmd(user));
    }

    public UserQuery createUserQuery() {
        return (UserQuery)this.commandExecutor.execute((Command)new CreateUserQueryCmd());
    }

    public NativeUserQuery createNativeUserQuery() {
        return new NativeUserQueryImpl(this.commandExecutor);
    }

    public GroupQuery createGroupQuery() {
        return (GroupQuery)this.commandExecutor.execute((Command)new CreateGroupQueryCmd());
    }

    public NativeGroupQuery createNativeGroupQuery() {
        return new NativeGroupQueryImpl(this.commandExecutor);
    }

    public void createMembership(String userId, String groupId) {
        this.commandExecutor.execute((Command)new CreateMembershipCmd(userId, groupId));
    }

    public void deleteGroup(String groupId) {
        this.commandExecutor.execute((Command)new DeleteGroupCmd(groupId));
    }

    public void deleteMembership(String userId, String groupId) {
        this.commandExecutor.execute((Command)new DeleteMembershipCmd(userId, groupId));
    }

    public boolean checkPassword(String userId, String password) {
        return (Boolean)this.commandExecutor.execute((Command)new CheckPassword(userId, password));
    }

    public void setAuthenticatedUserId(String authenticatedUserId) {
        Authentication.setAuthenticatedUserId((String)authenticatedUserId);
    }

    public void deleteUser(String userId) {
        this.commandExecutor.execute((Command)new DeleteUserCmd(userId));
    }

    public Token newToken(String tokenId) {
        return (Token)this.commandExecutor.execute((Command)new CreateTokenCmd(tokenId));
    }

    public void saveToken(Token token) {
        this.commandExecutor.execute((Command)new SaveTokenCmd(token));
    }

    public void deleteToken(String tokenId) {
        this.commandExecutor.execute((Command)new DeleteTokenCmd(tokenId));
    }

    public TokenQuery createTokenQuery() {
        return (TokenQuery)this.commandExecutor.execute((Command)new CreateTokenQueryCmd());
    }

    public NativeTokenQuery createNativeTokenQuery() {
        return new NativeTokenQueryImpl(this.commandExecutor);
    }

    public void setUserPicture(String userId, Picture picture) {
        this.commandExecutor.execute((Command)new SetUserPictureCmd(userId, picture));
    }

    public Picture getUserPicture(String userId) {
        return (Picture)this.commandExecutor.execute((Command)new GetUserPictureCmd(userId));
    }

    public String getUserInfo(String userId, String key) {
        return (String)this.commandExecutor.execute((Command)new GetUserInfoCmd(userId, key));
    }

    public List<String> getUserInfoKeys(String userId) {
        return (List)this.commandExecutor.execute((Command)new GetUserInfoKeysCmd(userId, "userinfo"));
    }

    public void setUserInfo(String userId, String key, String value) {
        this.commandExecutor.execute((Command)new SetUserInfoCmd(userId, key, value));
    }

    public void deleteUserInfo(String userId, String key) {
        this.commandExecutor.execute((Command)new DeleteUserInfoCmd(userId, key));
    }

    public Privilege createPrivilege(String name) {
        return (Privilege)this.commandExecutor.execute((Command)new CreatePrivilegeCmd(name));
    }

    public void addUserPrivilegeMapping(String privilegeId, String userId) {
        this.commandExecutor.execute((Command)new AddPrivilegeMappingCmd(privilegeId, userId, null));
    }

    public void deleteUserPrivilegeMapping(String privilegeId, String userId) {
        this.commandExecutor.execute((Command)new DeletePrivilegeMappingCmd(privilegeId, userId, null));
    }

    public void addGroupPrivilegeMapping(String privilegeId, String groupId) {
        this.commandExecutor.execute((Command)new AddPrivilegeMappingCmd(privilegeId, null, groupId));
    }

    public void deleteGroupPrivilegeMapping(String privilegeId, String groupId) {
        this.commandExecutor.execute((Command)new DeletePrivilegeMappingCmd(privilegeId, null, groupId));
    }

    public List<PrivilegeMapping> getPrivilegeMappingsByPrivilegeId(String privilegeId) {
        return (List)this.commandExecutor.execute((Command)new GetPrivilegeMappingsByPrivilegeIdCmd(privilegeId));
    }

    public void deletePrivilege(String id) {
        this.commandExecutor.execute((Command)new DeletePrivilegeCmd(id));
    }

    public PrivilegeQuery createPrivilegeQuery() {
        return (PrivilegeQuery)this.commandExecutor.execute((Command)new CreatePrivilegeQueryCmd());
    }

    public List<Group> getGroupsWithPrivilege(String name) {
        return (List)this.commandExecutor.execute((Command)new GetGroupsWithPrivilegeCmd(name));
    }

    public List<User> getUsersWithPrivilege(String name) {
        return (List)this.commandExecutor.execute((Command)new GetUsersWithPrivilegeCmd(name));
    }
}

