/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.spring.autodeployment;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.flowable.form.api.FormDeploymentBuilder;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.spring.autodeployment.AbstractAutoDeploymentStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class ResourceParentFolderAutoDeploymentStrategy
extends AbstractAutoDeploymentStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceParentFolderAutoDeploymentStrategy.class);
    public static final String DEPLOYMENT_MODE = "resource-parent-folder";
    private static final String DEPLOYMENT_NAME_PATTERN = "%s.%s";

    @Override
    protected String getDeploymentMode() {
        return DEPLOYMENT_MODE;
    }

    @Override
    public void deployResources(String deploymentNameHint, Resource[] resources, FormRepositoryService repositoryService) {
        Map<String, Set<Resource>> resourcesMap = this.createMap(resources);
        for (Map.Entry<String, Set<Resource>> group : resourcesMap.entrySet()) {
            try {
                String deploymentName = this.determineDeploymentName(deploymentNameHint, group.getKey());
                FormDeploymentBuilder deploymentBuilder = repositoryService.createDeployment().enableDuplicateFiltering().name(deploymentName);
                for (Resource resource : group.getValue()) {
                    String resourceName = this.determineResourceName(resource);
                    deploymentBuilder.addInputStream(resourceName, resource.getInputStream());
                }
                deploymentBuilder.deploy();
            }
            catch (Exception e) {
                LOGGER.warn("Exception while autodeploying process definitions. This exception can be ignored if the root cause indicates a unique constraint violation, which is typically caused by two (or more) servers booting up at the exact same time and deploying the same definitions. ", (Throwable)e);
            }
        }
    }

    private Map<String, Set<Resource>> createMap(Resource[] resources) {
        HashMap<String, Set<Resource>> resourcesMap = new HashMap<String, Set<Resource>>();
        for (Resource resource : resources) {
            String parentFolderName = this.determineGroupName(resource);
            if (resourcesMap.get(parentFolderName) == null) {
                resourcesMap.put(parentFolderName, new HashSet());
            }
            ((Set)resourcesMap.get(parentFolderName)).add(resource);
        }
        return resourcesMap;
    }

    private String determineGroupName(Resource resource) {
        String result = this.determineResourceName(resource);
        try {
            if (this.resourceParentIsDirectory(resource)) {
                result = resource.getFile().getParentFile().getName();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private boolean resourceParentIsDirectory(Resource resource) throws IOException {
        return resource.getFile() != null && resource.getFile().getParentFile() != null && resource.getFile().getParentFile().isDirectory();
    }

    private String determineDeploymentName(String deploymentNameHint, String groupName) {
        return String.format(DEPLOYMENT_NAME_PATTERN, deploymentNameHint, groupName);
    }
}

