/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl;

import java.util.Map;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.service.CommonEngineServiceImpl;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormInstance;
import org.flowable.form.api.FormInstanceInfo;
import org.flowable.form.api.FormInstanceQuery;
import org.flowable.form.api.FormService;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.impl.FormInstanceQueryImpl;
import org.flowable.form.engine.impl.cmd.CreateFormInstanceCmd;
import org.flowable.form.engine.impl.cmd.DeleteFormInstanceCmd;
import org.flowable.form.engine.impl.cmd.DeleteFormInstancesByFormDefinitionCmd;
import org.flowable.form.engine.impl.cmd.DeleteFormInstancesByProcessDefinitionCmd;
import org.flowable.form.engine.impl.cmd.DeleteFormInstancesByScopeDefinitionCmd;
import org.flowable.form.engine.impl.cmd.GetFormInstanceByScopeModelCmd;
import org.flowable.form.engine.impl.cmd.GetFormInstanceModelCmd;
import org.flowable.form.engine.impl.cmd.GetFormInstanceValuesCmd;
import org.flowable.form.engine.impl.cmd.GetFormModelWithVariablesCmd;
import org.flowable.form.engine.impl.cmd.GetVariablesFromFormSubmissionCmd;
import org.flowable.form.engine.impl.cmd.SaveFormInstanceCmd;

public class FormServiceImpl
extends CommonEngineServiceImpl<FormEngineConfiguration>
implements FormService {
    public FormServiceImpl(FormEngineConfiguration engineConfiguration) {
        super((AbstractEngineConfiguration)engineConfiguration);
    }

    public void validateFormFields(String elementId, String elementType, String scopeId, String scopeDefinitionId, String scopeType, FormInfo formInfo, Map<String, Object> values) {
    }

    public Map<String, Object> getVariablesFromFormSubmission(FormInfo formInfo, Map<String, Object> values) {
        return (Map)this.commandExecutor.execute((Command)new GetVariablesFromFormSubmissionCmd(formInfo, values));
    }

    public Map<String, Object> getVariablesFromFormSubmission(String elementId, String elementType, String scopeId, String scopeDefinitionId, String scopeType, FormInfo formInfo, Map<String, Object> values, String outcome) {
        return (Map)this.commandExecutor.execute((Command)new GetVariablesFromFormSubmissionCmd(formInfo, values, outcome));
    }

    public FormInstance createFormInstance(Map<String, Object> variables, FormInfo formInfo, String taskId, String processInstanceId, String processDefinitionId, String tenantId, String outcome) {
        return (FormInstance)this.commandExecutor.execute((Command)new CreateFormInstanceCmd(formInfo, variables, taskId, processInstanceId, processDefinitionId, tenantId, outcome));
    }

    public FormInstance saveFormInstance(Map<String, Object> variables, FormInfo formInfo, String taskId, String processInstanceId, String processDefinitionId, String tenantId, String outcome) {
        return (FormInstance)this.commandExecutor.execute((Command)new SaveFormInstanceCmd(formInfo, variables, taskId, processInstanceId, processDefinitionId, tenantId, outcome));
    }

    public FormInstance saveFormInstanceByFormDefinitionId(Map<String, Object> variables, String formDefinitionId, String taskId, String processInstanceId, String processDefinitionId, String tenantId, String outcome) {
        return (FormInstance)this.commandExecutor.execute((Command)new SaveFormInstanceCmd(formDefinitionId, variables, taskId, processInstanceId, processDefinitionId, tenantId, outcome));
    }

    public FormInstance createFormInstanceWithScopeId(Map<String, Object> variables, FormInfo formInfo, String taskId, String scopeId, String scopeType, String scopeDefinitionId, String tenantId, String outcome) {
        return (FormInstance)this.commandExecutor.execute((Command)new CreateFormInstanceCmd(formInfo, variables, taskId, scopeId, scopeType, scopeDefinitionId, tenantId, outcome));
    }

    public FormInstance saveFormInstanceWithScopeId(Map<String, Object> variables, FormInfo formInfo, String taskId, String scopeId, String scopeType, String scopeDefinitionId, String tenantId, String outcome) {
        return (FormInstance)this.commandExecutor.execute((Command)new SaveFormInstanceCmd(formInfo, variables, taskId, scopeId, scopeType, scopeDefinitionId, tenantId, outcome));
    }

    public FormInstance saveFormInstanceWithScopeId(Map<String, Object> variables, String formModelId, String taskId, String scopeId, String scopeType, String scopeDefinitionId, String tenantId, String outcome) {
        return (FormInstance)this.commandExecutor.execute((Command)new SaveFormInstanceCmd(formModelId, variables, taskId, scopeId, scopeType, scopeDefinitionId, tenantId, outcome));
    }

    public FormInfo getFormModelWithVariablesById(String formDefinitionId, String taskId, Map<String, Object> variables) {
        return (FormInfo)this.commandExecutor.execute((Command)new GetFormModelWithVariablesCmd(null, formDefinitionId, taskId, variables));
    }

    public FormInfo getFormModelWithVariablesById(String formDefinitionId, String taskId, Map<String, Object> variables, String tenantId, boolean fallbackToDefaultTenant) {
        return (FormInfo)this.commandExecutor.execute((Command)new GetFormModelWithVariablesCmd(null, null, formDefinitionId, taskId, tenantId, variables, fallbackToDefaultTenant));
    }

    public FormInfo getFormModelWithVariablesByKey(String formDefinitionKey, String taskId, Map<String, Object> variables) {
        return (FormInfo)this.commandExecutor.execute((Command)new GetFormModelWithVariablesCmd(formDefinitionKey, null, taskId, variables));
    }

    public FormInfo getFormModelWithVariablesByKey(String formDefinitionKey, String taskId, Map<String, Object> variables, String tenantId, boolean fallbackToDefaultTenant) {
        return (FormInfo)this.commandExecutor.execute((Command)new GetFormModelWithVariablesCmd(formDefinitionKey, null, null, taskId, tenantId, variables, fallbackToDefaultTenant));
    }

    public FormInfo getFormModelWithVariablesByKeyAndParentDeploymentId(String formDefinitionKey, String parentDeploymentId, String taskId, Map<String, Object> variables) {
        return (FormInfo)this.commandExecutor.execute((Command)new GetFormModelWithVariablesCmd(formDefinitionKey, parentDeploymentId, null, taskId, variables));
    }

    public FormInfo getFormModelWithVariablesByKeyAndParentDeploymentId(String formDefinitionKey, String parentDeploymentId, String taskId, Map<String, Object> variables, String tenantId, boolean fallbackToDefaultTenant) {
        return (FormInfo)this.commandExecutor.execute((Command)new GetFormModelWithVariablesCmd(formDefinitionKey, parentDeploymentId, null, taskId, tenantId, variables, fallbackToDefaultTenant));
    }

    public FormInstanceInfo getFormInstanceModelById(String formInstanceId, Map<String, Object> variables) {
        return (FormInstanceInfo)this.commandExecutor.execute((Command)new GetFormInstanceModelCmd(formInstanceId, variables));
    }

    public FormInstanceInfo getFormInstanceModelById(String formDefinitionId, String taskId, String processInstanceId, Map<String, Object> variables) {
        return (FormInstanceInfo)this.commandExecutor.execute((Command)new GetFormInstanceModelCmd(null, formDefinitionId, taskId, processInstanceId, variables));
    }

    public FormInstanceInfo getFormInstanceModelById(String formDefinitionId, String taskId, String processInstanceId, Map<String, Object> variables, String tenantId, boolean fallbackToDefaultTenant) {
        return (FormInstanceInfo)this.commandExecutor.execute((Command)new GetFormInstanceModelCmd(null, null, formDefinitionId, taskId, processInstanceId, tenantId, variables, fallbackToDefaultTenant));
    }

    public FormInstanceInfo getFormInstanceModelByKey(String formDefinitionKey, String taskId, String processInstanceId, Map<String, Object> variables) {
        return (FormInstanceInfo)this.commandExecutor.execute((Command)new GetFormInstanceModelCmd(formDefinitionKey, null, taskId, processInstanceId, variables));
    }

    public FormInstanceInfo getFormInstanceModelByKey(String formDefinitionKey, String taskId, String processInstanceId, Map<String, Object> variables, String tenantId, boolean fallbackToDefaultTenant) {
        return (FormInstanceInfo)this.commandExecutor.execute((Command)new GetFormInstanceModelCmd(formDefinitionKey, null, null, taskId, processInstanceId, tenantId, variables, fallbackToDefaultTenant));
    }

    public FormInstanceInfo getFormInstanceModelByKeyAndParentDeploymentId(String formDefinitionKey, String parentDeploymentId, String taskId, String processInstanceId, Map<String, Object> variables) {
        return (FormInstanceInfo)this.commandExecutor.execute((Command)new GetFormInstanceModelCmd(formDefinitionKey, parentDeploymentId, null, taskId, processInstanceId, variables));
    }

    public FormInstanceInfo getFormInstanceModelByKeyAndParentDeploymentId(String formDefinitionKey, String parentDeploymentId, String taskId, String processInstanceId, Map<String, Object> variables, String tenantId, boolean fallbackToDefaultTenant) {
        return (FormInstanceInfo)this.commandExecutor.execute((Command)new GetFormInstanceModelCmd(formDefinitionKey, parentDeploymentId, null, taskId, processInstanceId, tenantId, variables, fallbackToDefaultTenant));
    }

    public FormInstanceInfo getFormInstanceModelByKeyAndScopeId(String formDefinitionKey, String scopeId, String scopeType, Map<String, Object> variables) {
        return (FormInstanceInfo)this.commandExecutor.execute((Command)new GetFormInstanceByScopeModelCmd(formDefinitionKey, scopeId, scopeType, null, variables));
    }

    public FormInstanceInfo getFormInstanceModelByKeyAndScopeId(String formDefinitionKey, String scopeId, String scopeType, Map<String, Object> variables, String tenantId, boolean fallbackToDefaultTenant) {
        return (FormInstanceInfo)this.commandExecutor.execute((Command)new GetFormInstanceByScopeModelCmd(formDefinitionKey, null, scopeId, scopeType, tenantId, variables, fallbackToDefaultTenant));
    }

    public FormInstanceInfo getFormInstanceModelByKeyAndParentDeploymentIdAndScopeId(String formDefinitionKey, String parentDeploymentId, String scopeId, String scopeType, Map<String, Object> variables) {
        return (FormInstanceInfo)this.commandExecutor.execute((Command)new GetFormInstanceByScopeModelCmd(formDefinitionKey, parentDeploymentId, scopeId, scopeType, null, variables, false));
    }

    public FormInstanceInfo getFormInstanceModelByKeyAndParentDeploymentIdAndScopeId(String formDefinitionKey, String parentDeploymentId, String scopeId, String scopeType, Map<String, Object> variables, String tenantId, boolean fallbackToDefaultTenant) {
        return (FormInstanceInfo)this.commandExecutor.execute((Command)new GetFormInstanceByScopeModelCmd(formDefinitionKey, parentDeploymentId, scopeId, scopeType, tenantId, variables, fallbackToDefaultTenant));
    }

    public byte[] getFormInstanceValues(String formInstanceId) {
        return (byte[])this.commandExecutor.execute((Command)new GetFormInstanceValuesCmd(formInstanceId));
    }

    public FormInstanceQuery createFormInstanceQuery() {
        return new FormInstanceQueryImpl(this.commandExecutor);
    }

    public void deleteFormInstance(String formInstanceId) {
        this.commandExecutor.execute((Command)new DeleteFormInstanceCmd(formInstanceId));
    }

    public void deleteFormInstancesByFormDefinition(String formDefinitionId) {
        this.commandExecutor.execute((Command)new DeleteFormInstancesByFormDefinitionCmd(formDefinitionId));
    }

    public void deleteFormInstancesByProcessDefinition(String processDefinitionId) {
        this.commandExecutor.execute((Command)new DeleteFormInstancesByProcessDefinitionCmd(processDefinitionId));
    }

    public void deleteFormInstancesByScopeDefinition(String scopeDefinitionId) {
        this.commandExecutor.execute((Command)new DeleteFormInstancesByScopeDefinitionCmd(scopeDefinitionId));
    }
}

