/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import java.util.HashSet;
import java.util.List;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.HistoryManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.entitylink.api.EntityLink;
import org.flowable.entitylink.api.EntityLinkService;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntity;

public class EntityLinkUtil {
    public static void createEntityLinks(String scopeId, String subScopeId, String parentElementId, String referenceScopeId, String referenceScopeType) {
        String rootScopeType;
        String rootScopeId;
        String hierarchyType;
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        EntityLinkService entityLinkService = processEngineConfiguration.getEntityLinkServiceConfiguration().getEntityLinkService();
        List scopeParentEntityLinks = entityLinkService.findEntityLinksByReferenceScopeIdAndType(scopeId, "bpmn", "child");
        HashSet<String> parentIds = new HashSet<String>();
        HistoryManager historyManager = CommandContextUtil.getHistoryManager();
        EntityLink scopeRootEntityLink = null;
        for (EntityLink parentEntityLink : scopeParentEntityLinks) {
            if (parentIds.contains(parentEntityLink.getScopeId())) continue;
            String newHierarchyType = null;
            if ("root".equals(parentEntityLink.getHierarchyType())) {
                scopeRootEntityLink = parentEntityLink;
                newHierarchyType = "root";
            } else if ("parent".equals(parentEntityLink.getHierarchyType()) && "task".equals(referenceScopeType)) {
                newHierarchyType = "grandParent";
            }
            EntityLinkUtil.copyAndCreateEntityLink(subScopeId, parentElementId, referenceScopeId, referenceScopeType, newHierarchyType, parentEntityLink, entityLinkService, historyManager);
            parentIds.add(parentEntityLink.getScopeId());
        }
        if (scopeRootEntityLink != null) {
            hierarchyType = "parent";
            rootScopeId = scopeRootEntityLink.getRootScopeId();
            rootScopeType = scopeRootEntityLink.getRootScopeType();
        } else {
            hierarchyType = "root";
            rootScopeId = scopeId;
            rootScopeType = "bpmn";
        }
        EntityLinkUtil.createEntityLink(scopeId, subScopeId, parentElementId, referenceScopeId, referenceScopeType, hierarchyType, rootScopeId, rootScopeType, entityLinkService, historyManager);
    }

    protected static EntityLinkEntity copyAndCreateEntityLink(String subScopeId, String parentElementId, String referenceScopeId, String referenceScopeType, String hierarchyType, EntityLink parentEntityLink, EntityLinkService entityLinkService, HistoryManager historyManager) {
        EntityLinkEntity newEntityLink = (EntityLinkEntity)entityLinkService.createEntityLink();
        newEntityLink.setLinkType("child");
        newEntityLink.setScopeId(parentEntityLink.getScopeId());
        newEntityLink.setSubScopeId(subScopeId);
        newEntityLink.setScopeType(parentEntityLink.getScopeType());
        newEntityLink.setScopeDefinitionId(parentEntityLink.getScopeDefinitionId());
        newEntityLink.setParentElementId(parentElementId);
        newEntityLink.setReferenceScopeId(referenceScopeId);
        newEntityLink.setReferenceScopeType(referenceScopeType);
        newEntityLink.setHierarchyType(hierarchyType);
        newEntityLink.setRootScopeId(parentEntityLink.getRootScopeId());
        newEntityLink.setRootScopeType(parentEntityLink.getRootScopeType());
        entityLinkService.insertEntityLink((EntityLink)newEntityLink);
        historyManager.recordEntityLinkCreated(newEntityLink);
        return newEntityLink;
    }

    protected static EntityLinkEntity createEntityLink(String scopeId, String subScopeId, String parentElementId, String referenceScopeId, String referenceScopeType, String hierarchyType, String rootScopeId, String rootScopeType, EntityLinkService entityLinkService, HistoryManager historyManager) {
        EntityLinkEntity newEntityLink = (EntityLinkEntity)entityLinkService.createEntityLink();
        newEntityLink.setLinkType("child");
        newEntityLink.setScopeId(scopeId);
        newEntityLink.setSubScopeId(subScopeId);
        newEntityLink.setScopeType("bpmn");
        newEntityLink.setParentElementId(parentElementId);
        newEntityLink.setReferenceScopeId(referenceScopeId);
        newEntityLink.setReferenceScopeType(referenceScopeType);
        newEntityLink.setHierarchyType(hierarchyType);
        newEntityLink.setRootScopeId(rootScopeId);
        newEntityLink.setRootScopeType(rootScopeType);
        entityLinkService.insertEntityLink((EntityLink)newEntityLink);
        historyManager.recordEntityLinkCreated(newEntityLink);
        return newEntityLink;
    }
}

