/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.Map;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.cmd.NeedsActiveTaskCmd;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class SetTaskVariablesCmd
extends NeedsActiveTaskCmd<Object> {
    private static final long serialVersionUID = 1L;
    protected Map<String, ? extends Object> variables;
    protected boolean isLocal;

    public SetTaskVariablesCmd(String taskId, Map<String, ? extends Object> variables, boolean isLocal) {
        super(taskId);
        this.taskId = taskId;
        this.variables = variables;
        this.isLocal = isLocal;
    }

    @Override
    protected Object execute(CommandContext commandContext, TaskEntity task) {
        if (task.getProcessDefinitionId() != null && Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, task.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            compatibilityHandler.setTaskVariables(this.taskId, this.variables, this.isLocal);
            return null;
        }
        if (this.isLocal) {
            if (this.variables != null) {
                for (String variableName : this.variables.keySet()) {
                    task.setVariableLocal(variableName, this.variables.get(variableName), false);
                }
            }
        } else if (this.variables != null) {
            for (String variableName : this.variables.keySet()) {
                task.setVariable(variableName, this.variables.get(variableName), false);
            }
        }
        task.forceUpdate();
        return null;
    }

    @Override
    protected String getSuspendedTaskExceptionPrefix() {
        return "Cannot add variables to";
    }
}

