/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Message;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.DeploymentQueryImpl;
import org.flowable.engine.impl.ModelQueryImpl;
import org.flowable.engine.impl.ProcessDefinitionQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.event.EventDefinitionExpressionUtil;
import org.flowable.engine.impl.jobexecutor.TimerEventHandler;
import org.flowable.engine.impl.persistence.entity.AbstractProcessEngineEntityManager;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.DeploymentEntityManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.ModelEntity;
import org.flowable.engine.impl.persistence.entity.ModelEntityManager;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionInfoEntityManager;
import org.flowable.engine.impl.persistence.entity.ResourceEntity;
import org.flowable.engine.impl.persistence.entity.ResourceEntityManager;
import org.flowable.engine.impl.persistence.entity.data.DeploymentDataManager;
import org.flowable.engine.impl.util.CorrelationUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.util.TimerUtil;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.Model;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.api.EventSubscriptionBuilder;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.eventsubscription.service.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.flowable.eventsubscription.service.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.flowable.job.service.TimerJobService;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;

public class DeploymentEntityManagerImpl
extends AbstractProcessEngineEntityManager<DeploymentEntity, DeploymentDataManager>
implements DeploymentEntityManager {
    public DeploymentEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, DeploymentDataManager deploymentDataManager) {
        super(processEngineConfiguration, deploymentDataManager);
    }

    public void insert(DeploymentEntity deployment) {
        this.insert(deployment, false);
        for (EngineResource resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getResourceEntityManager().insert((ResourceEntity)resource);
        }
    }

    @Override
    public void deleteDeployment(String deploymentId, boolean cascade) {
        List processDefinitions = new ProcessDefinitionQueryImpl().deploymentId(deploymentId).list();
        this.updateRelatedModels(deploymentId);
        if (cascade) {
            this.deleteProcessInstancesForProcessDefinitions(processDefinitions);
            this.deleteHistoricTaskEventLogEntriesForProcessDefinitions(processDefinitions);
        }
        for (ProcessDefinition processDefinition : processDefinitions) {
            this.deleteProcessDefinitionIdentityLinks(processDefinition);
            this.deleteEventSubscriptions(processDefinition);
            this.deleteProcessDefinitionInfo(processDefinition.getId());
            this.removeTimerStartJobs(processDefinition);
            this.restorePreviousStartEventsIfNeeded(processDefinition);
        }
        this.deleteProcessDefinitionForDeployment(deploymentId);
        this.getResourceEntityManager().deleteResourcesByDeploymentId(deploymentId);
        this.delete(this.findById(deploymentId), false);
    }

    protected void updateRelatedModels(String deploymentId) {
        List models = new ModelQueryImpl().deploymentId(deploymentId).list();
        for (Model model : models) {
            ModelEntity modelEntity = (ModelEntity)model;
            modelEntity.setDeploymentId(null);
            this.getModelEntityManager().updateModel(modelEntity);
        }
    }

    protected void deleteProcessDefinitionIdentityLinks(ProcessDefinition processDefinition) {
        ((ProcessEngineConfigurationImpl)this.engineConfiguration).getIdentityLinkServiceConfiguration().getIdentityLinkService().deleteIdentityLinksByProcessDefinitionId(processDefinition.getId());
    }

    protected void deleteEventSubscriptions(ProcessDefinition processDefinition) {
        ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEventSubscriptionServiceConfiguration().getEventSubscriptionService().deleteEventSubscriptionsForProcessDefinition(processDefinition.getId());
    }

    protected void deleteProcessDefinitionInfo(String processDefinitionId) {
        this.getProcessDefinitionInfoEntityManager().deleteProcessDefinitionInfo(processDefinitionId);
    }

    protected void deleteProcessDefinitionForDeployment(String deploymentId) {
        this.getProcessDefinitionEntityManager().deleteProcessDefinitionsByDeploymentId(deploymentId);
    }

    protected void deleteProcessInstancesForProcessDefinitions(List<ProcessDefinition> processDefinitions) {
        for (ProcessDefinition processDefinition : processDefinitions) {
            this.getExecutionEntityManager().deleteProcessInstancesByProcessDefinition(processDefinition.getId(), "deleted deployment", true);
        }
    }

    protected void deleteHistoricTaskEventLogEntriesForProcessDefinitions(List<ProcessDefinition> processDefinitions) {
        for (ProcessDefinition processDefinition : processDefinitions) {
            ((ProcessEngineConfigurationImpl)this.engineConfiguration).getTaskServiceConfiguration().getHistoricTaskService().deleteHistoricTaskLogEntriesForProcessDefinition(processDefinition.getId());
        }
    }

    protected void removeTimerStartJobs(ProcessDefinition processDefinition) {
        TimerJobService timerJobService = ((ProcessEngineConfigurationImpl)this.engineConfiguration).getJobServiceConfiguration().getTimerJobService();
        List timerStartJobs = timerJobService.findJobsByTypeAndProcessDefinitionId("timer-start-event", processDefinition.getId());
        if (timerStartJobs != null && timerStartJobs.size() > 0) {
            for (TimerJobEntity timerStartJob : timerStartJobs) {
                if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
                    this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_CANCELED, timerStartJob, null, null, processDefinition.getId()), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
                }
                timerJobService.deleteTimerJob(timerStartJob);
            }
        }
    }

    protected void restorePreviousStartEventsIfNeeded(ProcessDefinition processDefinition) {
        ProcessDefinition previousProcessDefinition;
        ProcessDefinitionEntity latestProcessDefinition = this.findLatestProcessDefinition(processDefinition);
        if (latestProcessDefinition != null && processDefinition.getId().equals(latestProcessDefinition.getId()) && (previousProcessDefinition = this.findNewLatestProcessDefinitionAfterRemovalOf(processDefinition)) != null) {
            List startEvents;
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(previousProcessDefinition.getId());
            Process previousProcess = ProcessDefinitionUtil.getProcess(previousProcessDefinition.getId());
            if (CollectionUtil.isNotEmpty((Collection)previousProcess.getFlowElements()) && CollectionUtil.isNotEmpty((Collection)(startEvents = previousProcess.findFlowElementsOfType(StartEvent.class)))) {
                for (StartEvent startEvent : startEvents) {
                    List eventTypeElements;
                    if (CollectionUtil.isNotEmpty((Collection)startEvent.getEventDefinitions())) {
                        EventDefinition eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0);
                        if (eventDefinition instanceof TimerEventDefinition) {
                            this.restoreTimerStartEvent(previousProcessDefinition, startEvent, eventDefinition);
                            continue;
                        }
                        if (eventDefinition instanceof SignalEventDefinition) {
                            this.restoreSignalStartEvent(previousProcessDefinition, bpmnModel, startEvent, eventDefinition);
                            continue;
                        }
                        if (!(eventDefinition instanceof MessageEventDefinition)) continue;
                        this.restoreMessageStartEvent(previousProcessDefinition, bpmnModel, startEvent, eventDefinition);
                        continue;
                    }
                    if (startEvent.getExtensionElements().get("eventType") == null || (eventTypeElements = (List)startEvent.getExtensionElements().get("eventType")).isEmpty()) continue;
                    String eventDefinitionKey = ((ExtensionElement)eventTypeElements.get(0)).getElementText();
                    this.restoreEventRegistryStartEvent(previousProcessDefinition, bpmnModel, startEvent, eventDefinitionKey);
                }
            }
        }
    }

    protected void restoreTimerStartEvent(ProcessDefinition previousProcessDefinition, StartEvent startEvent, EventDefinition eventDefinition) {
        TimerEventDefinition timerEventDefinition = (TimerEventDefinition)eventDefinition;
        TimerJobEntity timer = TimerUtil.createTimerEntityForTimerEventDefinition((TimerEventDefinition)eventDefinition, (FlowElement)startEvent, false, null, "timer-start-event", TimerEventHandler.createConfiguration(startEvent.getId(), timerEventDefinition.getEndDate(), timerEventDefinition.getCalendarName()));
        if (timer != null) {
            TimerJobEntity timerJob = TimerUtil.createTimerEntityForTimerEventDefinition(timerEventDefinition, (FlowElement)startEvent, false, null, "timer-start-event", TimerEventHandler.createConfiguration(startEvent.getId(), timerEventDefinition.getEndDate(), timerEventDefinition.getCalendarName()));
            timerJob.setProcessDefinitionId(previousProcessDefinition.getId());
            if (previousProcessDefinition.getTenantId() != null) {
                timerJob.setTenantId(previousProcessDefinition.getTenantId());
            }
            ((ProcessEngineConfigurationImpl)this.engineConfiguration).getJobServiceConfiguration().getTimerJobService().scheduleTimerJob(timerJob);
        }
    }

    protected void restoreSignalStartEvent(ProcessDefinition previousProcessDefinition, BpmnModel bpmnModel, StartEvent startEvent, EventDefinition eventDefinition) {
        CommandContext commandContext = Context.getCommandContext();
        SignalEventDefinition signalEventDefinition = (SignalEventDefinition)eventDefinition;
        SignalEventSubscriptionEntity subscriptionEntity = ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEventSubscriptionServiceConfiguration().getEventSubscriptionService().createSignalEventSubscription();
        String eventName = EventDefinitionExpressionUtil.determineSignalName(commandContext, signalEventDefinition, bpmnModel, null);
        subscriptionEntity.setEventName(eventName);
        subscriptionEntity.setActivityId(startEvent.getId());
        subscriptionEntity.setProcessDefinitionId(previousProcessDefinition.getId());
        if (previousProcessDefinition.getTenantId() != null) {
            subscriptionEntity.setTenantId(previousProcessDefinition.getTenantId());
        }
        ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEventSubscriptionServiceConfiguration().getEventSubscriptionService().insertEventSubscription((EventSubscriptionEntity)subscriptionEntity);
        CountingEntityUtil.handleInsertEventSubscriptionEntityCount((EventSubscription)subscriptionEntity);
    }

    protected void restoreMessageStartEvent(ProcessDefinition previousProcessDefinition, BpmnModel bpmnModel, StartEvent startEvent, EventDefinition eventDefinition) {
        MessageEventDefinition messageEventDefinition = (MessageEventDefinition)eventDefinition;
        if (bpmnModel.containsMessageId(messageEventDefinition.getMessageRef())) {
            Message message = bpmnModel.getMessage(messageEventDefinition.getMessageRef());
            messageEventDefinition.setMessageRef(message.getName());
        }
        CommandContext commandContext = Context.getCommandContext();
        MessageEventSubscriptionEntity newSubscription = ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEventSubscriptionServiceConfiguration().getEventSubscriptionService().createMessageEventSubscription();
        String messageName = EventDefinitionExpressionUtil.determineMessageName(commandContext, messageEventDefinition, null);
        newSubscription.setEventName(messageName);
        newSubscription.setActivityId(startEvent.getId());
        newSubscription.setConfiguration(previousProcessDefinition.getId());
        newSubscription.setProcessDefinitionId(previousProcessDefinition.getId());
        if (previousProcessDefinition.getTenantId() != null) {
            newSubscription.setTenantId(previousProcessDefinition.getTenantId());
        }
        ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEventSubscriptionServiceConfiguration().getEventSubscriptionService().insertEventSubscription((EventSubscriptionEntity)newSubscription);
        CountingEntityUtil.handleInsertEventSubscriptionEntityCount((EventSubscription)newSubscription);
    }

    protected void restoreEventRegistryStartEvent(ProcessDefinition previousProcessDefinition, BpmnModel bpmnModel, StartEvent startEvent, String eventDefinitionKey) {
        CommandContext commandContext = Context.getCommandContext();
        EventSubscriptionService eventSubscriptionService = ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
        EventSubscriptionBuilder eventSubscriptionBuilder = eventSubscriptionService.createEventSubscriptionBuilder().eventType(eventDefinitionKey).activityId(startEvent.getId()).processDefinitionId(previousProcessDefinition.getId()).scopeType("bpmn").configuration(CorrelationUtil.getCorrelationKey("eventCorrelationParameter", commandContext, (FlowElement)startEvent, null));
        if (previousProcessDefinition.getTenantId() != null) {
            eventSubscriptionBuilder.tenantId(previousProcessDefinition.getTenantId());
        }
        EventSubscription eventSubscription = eventSubscriptionBuilder.create();
        CountingEntityUtil.handleInsertEventSubscriptionEntityCount(eventSubscription);
    }

    protected ProcessDefinitionEntity findLatestProcessDefinition(ProcessDefinition processDefinition) {
        ProcessDefinitionEntity latestProcessDefinition = null;
        latestProcessDefinition = processDefinition.getTenantId() != null && !"".equals(processDefinition.getTenantId()) ? this.getProcessDefinitionEntityManager().findLatestProcessDefinitionByKeyAndTenantId(processDefinition.getKey(), processDefinition.getTenantId()) : this.getProcessDefinitionEntityManager().findLatestProcessDefinitionByKey(processDefinition.getKey());
        return latestProcessDefinition;
    }

    protected ProcessDefinition findNewLatestProcessDefinitionAfterRemovalOf(ProcessDefinition processDefinitionToBeRemoved) {
        ProcessDefinitionQueryImpl query = new ProcessDefinitionQueryImpl();
        query.processDefinitionKey(processDefinitionToBeRemoved.getKey());
        if (processDefinitionToBeRemoved.getTenantId() != null && !"".equals(processDefinitionToBeRemoved.getTenantId())) {
            query.processDefinitionTenantId(processDefinitionToBeRemoved.getTenantId());
        } else {
            query.processDefinitionWithoutTenantId();
        }
        if (processDefinitionToBeRemoved.getVersion() > 0) {
            query.processDefinitionVersionLowerThan(processDefinitionToBeRemoved.getVersion());
        }
        query.orderByProcessDefinitionVersion().desc();
        query.setFirstResult(0);
        query.setMaxResults(1);
        List<ProcessDefinition> processDefinitions = this.getProcessDefinitionEntityManager().findProcessDefinitionsByQueryCriteria(query);
        if (processDefinitions != null && processDefinitions.size() > 0) {
            return processDefinitions.get(0);
        }
        return null;
    }

    @Override
    public long findDeploymentCountByQueryCriteria(DeploymentQueryImpl deploymentQuery) {
        return ((DeploymentDataManager)this.dataManager).findDeploymentCountByQueryCriteria(deploymentQuery);
    }

    @Override
    public List<Deployment> findDeploymentsByQueryCriteria(DeploymentQueryImpl deploymentQuery) {
        return ((DeploymentDataManager)this.dataManager).findDeploymentsByQueryCriteria(deploymentQuery);
    }

    @Override
    public List<String> getDeploymentResourceNames(String deploymentId) {
        return ((DeploymentDataManager)this.dataManager).getDeploymentResourceNames(deploymentId);
    }

    @Override
    public List<Deployment> findDeploymentsByNativeQuery(Map<String, Object> parameterMap) {
        return ((DeploymentDataManager)this.dataManager).findDeploymentsByNativeQuery(parameterMap);
    }

    @Override
    public long findDeploymentCountByNativeQuery(Map<String, Object> parameterMap) {
        return ((DeploymentDataManager)this.dataManager).findDeploymentCountByNativeQuery(parameterMap);
    }

    protected ResourceEntityManager getResourceEntityManager() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getResourceEntityManager();
    }

    protected ModelEntityManager getModelEntityManager() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getModelEntityManager();
    }

    protected ProcessDefinitionEntityManager getProcessDefinitionEntityManager() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getProcessDefinitionEntityManager();
    }

    protected ProcessDefinitionInfoEntityManager getProcessDefinitionInfoEntityManager() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getProcessDefinitionInfoEntityManager();
    }

    protected ExecutionEntityManager getExecutionEntityManager() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getExecutionEntityManager();
    }
}

