/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.ExecutionListener;
import org.flowable.engine.delegate.JavaDelegate;
import org.flowable.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.delegate.TriggerableActivityBehavior;
import org.flowable.engine.impl.delegate.invocation.JavaDelegateInvocation;
import org.flowable.engine.impl.util.BpmnLoggingSessionUtil;
import org.flowable.engine.impl.util.CommandContextUtil;

public class ServiceTaskJavaDelegateActivityBehavior
extends TaskActivityBehavior
implements ActivityBehavior,
ExecutionListener {
    private static final long serialVersionUID = 1L;
    protected JavaDelegate javaDelegate;
    protected Expression skipExpression;
    protected boolean triggerable;

    protected ServiceTaskJavaDelegateActivityBehavior() {
    }

    public ServiceTaskJavaDelegateActivityBehavior(JavaDelegate javaDelegate, boolean triggerable, Expression skipExpression) {
        this.javaDelegate = javaDelegate;
        this.triggerable = triggerable;
        this.skipExpression = skipExpression;
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        if (this.triggerable && this.javaDelegate instanceof TriggerableActivityBehavior) {
            if (processEngineConfiguration.isLoggingSessionEnabled()) {
                BpmnLoggingSessionUtil.addLoggingData("serviceTaskBeforeTrigger", "Triggering service task with java class " + this.javaDelegate.getClass().getName(), execution);
            }
            ((TriggerableActivityBehavior)((Object)this.javaDelegate)).trigger(execution, signalName, signalData);
            if (processEngineConfiguration.isLoggingSessionEnabled()) {
                BpmnLoggingSessionUtil.addLoggingData("serviceTaskBeforeTrigger", "Triggered service task with java class " + this.javaDelegate.getClass().getName(), execution);
            }
            this.leave(execution);
        } else if (processEngineConfiguration.isLoggingSessionEnabled()) {
            if (!this.triggerable) {
                BpmnLoggingSessionUtil.addLoggingData("serviceTaskWrongTrigger", "Service task with java class triggered but not triggerable " + this.javaDelegate.getClass().getName(), execution);
            } else {
                BpmnLoggingSessionUtil.addLoggingData("serviceTaskWrongTrigger", "Service task with java class triggered but not implementing TriggerableActivityBehavior " + this.javaDelegate.getClass().getName(), execution);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute(DelegateExecution execution) {
        commandContext = CommandContextUtil.getCommandContext();
        skipExpressionText = null;
        if (this.skipExpression != null) {
            skipExpressionText = this.skipExpression.getExpressionText();
        }
        isSkipExpressionEnabled = SkipExpressionUtil.isSkipExpressionEnabled(skipExpressionText, execution.getCurrentActivityId(), execution, commandContext);
        processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        if (!isSkipExpressionEnabled || !SkipExpressionUtil.shouldSkipFlowElement(skipExpressionText, execution.getCurrentActivityId(), execution, commandContext)) {
            try {
                if (processEngineConfiguration.isLoggingSessionEnabled()) {
                    BpmnLoggingSessionUtil.addLoggingData("serviceTaskEnter", "Executing service task with java class " + this.javaDelegate.getClass().getName(), execution);
                }
                processEngineConfiguration.getDelegateInterceptor().handleInvocation(new JavaDelegateInvocation(this.javaDelegate, execution));
                if (!processEngineConfiguration.isLoggingSessionEnabled()) ** GOTO lbl21
                BpmnLoggingSessionUtil.addLoggingData("serviceTaskExit", "Executed service task with java class " + this.javaDelegate.getClass().getName(), execution);
            }
            catch (RuntimeException e) {
                if (processEngineConfiguration.isLoggingSessionEnabled()) {
                    BpmnLoggingSessionUtil.addErrorLoggingData("serviceTaskException", "Service task with java class " + this.javaDelegate.getClass().getName() + " threw exception " + e.getMessage(), e, execution);
                }
                throw e;
            }
        } else if (processEngineConfiguration.isLoggingSessionEnabled()) {
            BpmnLoggingSessionUtil.addLoggingData("skipTask", "Skipped service task " + execution.getCurrentActivityId() + " with skip expression " + skipExpressionText, execution);
        }
lbl21:
        // 5 sources

        if (!this.triggerable) {
            this.leave(execution);
        }
    }

    @Override
    public void notify(DelegateExecution execution) {
        this.execute(execution);
    }
}

