/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.test;

import java.lang.reflect.AnnotatedElement;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.cfg.CommandExecutorImpl;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.interceptor.CommandInterceptor;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngines;
import org.flowable.engine.impl.interceptor.CommandInvoker;
import org.flowable.engine.impl.interceptor.LoggingExecutionTreeCommandInvoker;
import org.flowable.engine.impl.test.InternalFlowableExtension;
import org.flowable.engine.test.EnableVerboseExecutionTreeLogging;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class PluggableFlowableExtension
extends InternalFlowableExtension {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{PluggableFlowableExtension.class});
    private static final String PROCESS_ENGINE = "cachedProcessEngine";

    @Override
    public void afterEach(ExtensionContext context) throws Exception {
        try {
            super.afterEach(context);
        }
        finally {
            if (AnnotationSupport.isAnnotated((AnnotatedElement)context.getRequiredTestClass(), EnableVerboseExecutionTreeLogging.class)) {
                this.swapCommandInvoker(this.getProcessEngine(context), false);
            }
        }
    }

    @Override
    protected ProcessEngine getProcessEngine(ExtensionContext context) {
        ProcessEngine processEngine = (ProcessEngine)this.getStore(context).getOrComputeIfAbsent((Object)PROCESS_ENGINE, key -> this.initializeProcessEngine(), ProcessEngine.class);
        Class testClass = context.getRequiredTestClass();
        if (AnnotationSupport.isAnnotated((AnnotatedElement)testClass, EnableVerboseExecutionTreeLogging.class)) {
            this.swapCommandInvoker(processEngine, true);
        }
        return processEngine;
    }

    protected ProcessEngine initializeProcessEngine() {
        this.logger.info("No cached process engine found for test. Retrieving the default engine.");
        ProcessEngines.destroy();
        ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();
        if (processEngine == null) {
            throw new FlowableException("no default process engine available");
        }
        return processEngine;
    }

    protected void swapCommandInvoker(ProcessEngine processEngine, boolean debug) {
        CommandExecutor commandExecutor = processEngine.getProcessEngineConfiguration().getCommandExecutor();
        if (commandExecutor instanceof CommandExecutorImpl) {
            CommandExecutorImpl commandExecutorImpl = (CommandExecutorImpl)commandExecutor;
            CommandInterceptor previousCommandInterceptor = null;
            for (CommandInterceptor commandInterceptor = commandExecutorImpl.getFirst(); commandInterceptor != null; commandInterceptor = commandInterceptor.getNext()) {
                boolean matches;
                boolean bl = matches = debug ? commandInterceptor instanceof CommandInvoker : commandInterceptor instanceof LoggingExecutionTreeCommandInvoker;
                if (matches) {
                    CommandInvoker commandInvoker;
                    CommandInvoker commandInvoker2 = commandInvoker = debug ? new LoggingExecutionTreeCommandInvoker() : new CommandInvoker();
                    if (previousCommandInterceptor != null) {
                        previousCommandInterceptor.setNext((CommandInterceptor)commandInvoker);
                    } else {
                        commandExecutorImpl.setFirst(previousCommandInterceptor);
                    }
                    break;
                }
                previousCommandInterceptor = commandInterceptor;
            }
        } else {
            this.logger.warn("Not using {}, ignoring the {} annotation", CommandExecutorImpl.class, EnableVerboseExecutionTreeLogging.class);
        }
    }

    @Override
    protected ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }
}

