/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.migration.ProcessInstanceMigrationValidationResult;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.migration.ProcessInstanceMigrationDocument;
import org.flowable.engine.migration.ProcessInstanceMigrationManager;

public class ProcessInstanceMigrationValidationCmd
implements Command<ProcessInstanceMigrationValidationResult> {
    protected ProcessInstanceMigrationDocument processInstanceMigrationDocument;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected int processDefinitionVersion;
    protected String processDefinitionTenantId;

    public static ProcessInstanceMigrationValidationCmd forProcessInstance(String processInstanceId, ProcessInstanceMigrationDocument processInstanceMigrationDocument) {
        if (processInstanceId == null) {
            throw new FlowableException("Must specify a process instance id to migrate");
        }
        if (processInstanceMigrationDocument == null) {
            throw new FlowableException("Must specify a process instance migration document");
        }
        ProcessInstanceMigrationValidationCmd cmd = new ProcessInstanceMigrationValidationCmd();
        cmd.processInstanceId = processInstanceId;
        cmd.processInstanceMigrationDocument = processInstanceMigrationDocument;
        return cmd;
    }

    public static ProcessInstanceMigrationValidationCmd forProcessDefinition(String processDefinitionId, ProcessInstanceMigrationDocument processInstanceMigrationDocument) {
        if (processDefinitionId == null) {
            throw new FlowableException("Must specify a process definition id to migrate");
        }
        if (processInstanceMigrationDocument == null) {
            throw new FlowableException("Must specify a process instance migration document");
        }
        ProcessInstanceMigrationValidationCmd cmd = new ProcessInstanceMigrationValidationCmd();
        cmd.processDefinitionId = processDefinitionId;
        cmd.processInstanceMigrationDocument = processInstanceMigrationDocument;
        return cmd;
    }

    public static ProcessInstanceMigrationValidationCmd forProcessDefinition(String processDefinitionKey, int processDefinitionVersion, String processDefinitionTenantId, ProcessInstanceMigrationDocument processInstanceMigrationDocument) {
        if (processDefinitionKey == null) {
            throw new FlowableException("Must specify the process definition key to migrate");
        }
        if (processDefinitionVersion < 0) {
            throw new FlowableException("Must specify a valid version number to migrate");
        }
        if (processInstanceMigrationDocument == null) {
            throw new FlowableException("Must specify a process instance migration document");
        }
        ProcessInstanceMigrationValidationCmd cmd = new ProcessInstanceMigrationValidationCmd();
        cmd.processDefinitionKey = processDefinitionKey;
        cmd.processDefinitionVersion = processDefinitionVersion;
        cmd.processDefinitionTenantId = processDefinitionTenantId;
        cmd.processInstanceMigrationDocument = processInstanceMigrationDocument;
        return cmd;
    }

    public ProcessInstanceMigrationValidationResult execute(CommandContext commandContext) {
        ProcessInstanceMigrationManager migrationManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getProcessInstanceMigrationManager();
        if (this.processInstanceId != null) {
            return migrationManager.validateMigrateProcessInstance(this.processInstanceId, this.processInstanceMigrationDocument, commandContext);
        }
        if (this.processDefinitionId != null) {
            return migrationManager.validateMigrateProcessInstancesOfProcessDefinition(this.processDefinitionId, this.processInstanceMigrationDocument, commandContext);
        }
        if (this.processDefinitionKey != null && this.processDefinitionVersion >= 0) {
            return migrationManager.validateMigrateProcessInstancesOfProcessDefinition(this.processDefinitionKey, this.processDefinitionVersion, this.processDefinitionTenantId, this.processInstanceMigrationDocument, commandContext);
        }
        throw new FlowableException("Cannot validate process migration, not enough information");
    }
}

