/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.event.logger;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.engine.common.api.delegate.event.AbstractFlowableEventListener;
import org.flowable.engine.common.api.delegate.event.FlowableEngineEventType;
import org.flowable.engine.common.api.delegate.event.FlowableEntityEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.impl.context.Context;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.interceptor.CommandContextCloseListener;
import org.flowable.engine.common.impl.runtime.Clock;
import org.flowable.engine.impl.event.logger.DatabaseEventFlusher;
import org.flowable.engine.impl.event.logger.EventFlusher;
import org.flowable.engine.impl.event.logger.EventLoggerListener;
import org.flowable.engine.impl.event.logger.handler.ActivityCompensatedEventHandler;
import org.flowable.engine.impl.event.logger.handler.ActivityCompletedEventHandler;
import org.flowable.engine.impl.event.logger.handler.ActivityErrorReceivedEventHandler;
import org.flowable.engine.impl.event.logger.handler.ActivityMessageEventHandler;
import org.flowable.engine.impl.event.logger.handler.ActivitySignaledEventHandler;
import org.flowable.engine.impl.event.logger.handler.ActivityStartedEventHandler;
import org.flowable.engine.impl.event.logger.handler.EventLoggerEventHandler;
import org.flowable.engine.impl.event.logger.handler.ProcessInstanceEndedEventHandler;
import org.flowable.engine.impl.event.logger.handler.ProcessInstanceStartedEventHandler;
import org.flowable.engine.impl.event.logger.handler.SequenceFlowTakenEventHandler;
import org.flowable.engine.impl.event.logger.handler.TaskAssignedEventHandler;
import org.flowable.engine.impl.event.logger.handler.TaskCompletedEventHandler;
import org.flowable.engine.impl.event.logger.handler.TaskCreatedEventHandler;
import org.flowable.engine.impl.event.logger.handler.VariableCreatedEventHandler;
import org.flowable.engine.impl.event.logger.handler.VariableDeletedEventHandler;
import org.flowable.engine.impl.event.logger.handler.VariableUpdatedEventHandler;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLogger
extends AbstractFlowableEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventLogger.class);
    private static final String EVENT_FLUSHER_KEY = "eventFlusher";
    protected Clock clock;
    protected ObjectMapper objectMapper;
    protected Map<FlowableEngineEventType, Class<? extends EventLoggerEventHandler>> eventHandlers = new HashMap<FlowableEngineEventType, Class<? extends EventLoggerEventHandler>>();
    protected List<EventLoggerListener> listeners;

    public EventLogger() {
        this.initializeDefaultHandlers();
    }

    public EventLogger(Clock clock, ObjectMapper objectMapper) {
        this();
        this.clock = clock;
        this.objectMapper = objectMapper;
    }

    protected void initializeDefaultHandlers() {
        this.addEventHandler(FlowableEngineEventType.TASK_CREATED, TaskCreatedEventHandler.class);
        this.addEventHandler(FlowableEngineEventType.TASK_COMPLETED, TaskCompletedEventHandler.class);
        this.addEventHandler(FlowableEngineEventType.TASK_ASSIGNED, TaskAssignedEventHandler.class);
        this.addEventHandler(FlowableEngineEventType.SEQUENCEFLOW_TAKEN, SequenceFlowTakenEventHandler.class);
        this.addEventHandler(FlowableEngineEventType.ACTIVITY_COMPLETED, ActivityCompletedEventHandler.class);
        this.addEventHandler(FlowableEngineEventType.ACTIVITY_STARTED, ActivityStartedEventHandler.class);
        this.addEventHandler(FlowableEngineEventType.ACTIVITY_SIGNALED, ActivitySignaledEventHandler.class);
        this.addEventHandler(FlowableEngineEventType.ACTIVITY_MESSAGE_RECEIVED, ActivityMessageEventHandler.class);
        this.addEventHandler(FlowableEngineEventType.ACTIVITY_MESSAGE_WAITING, ActivityMessageEventHandler.class);
        this.addEventHandler(FlowableEngineEventType.ACTIVITY_COMPENSATE, ActivityCompensatedEventHandler.class);
        this.addEventHandler(FlowableEngineEventType.ACTIVITY_ERROR_RECEIVED, ActivityErrorReceivedEventHandler.class);
        this.addEventHandler(FlowableEngineEventType.VARIABLE_CREATED, VariableCreatedEventHandler.class);
        this.addEventHandler(FlowableEngineEventType.VARIABLE_DELETED, VariableDeletedEventHandler.class);
        this.addEventHandler(FlowableEngineEventType.VARIABLE_UPDATED, VariableUpdatedEventHandler.class);
    }

    public void onEvent(FlowableEvent event) {
        EventLoggerEventHandler eventHandler = this.getEventHandler(event);
        if (eventHandler != null) {
            CommandContext currentCommandContext = Context.getCommandContext();
            EventFlusher eventFlusher = (EventFlusher)currentCommandContext.getAttribute(EVENT_FLUSHER_KEY);
            if (eventFlusher == null) {
                eventFlusher = this.createEventFlusher();
                if (eventFlusher == null) {
                    eventFlusher = new DatabaseEventFlusher();
                }
                currentCommandContext.addAttribute(EVENT_FLUSHER_KEY, (Object)eventFlusher);
                currentCommandContext.addCloseListener((CommandContextCloseListener)eventFlusher);
                currentCommandContext.addCloseListener(new CommandContextCloseListener(){

                    public void closing(CommandContext commandContext) {
                    }

                    public void closed(CommandContext commandContext) {
                        if (EventLogger.this.listeners != null) {
                            for (EventLoggerListener listener : EventLogger.this.listeners) {
                                listener.eventsAdded(EventLogger.this);
                            }
                        }
                    }

                    public void afterSessionsFlush(CommandContext commandContext) {
                    }

                    public void closeFailure(CommandContext commandContext) {
                    }
                });
            }
            eventFlusher.addEventHandler(eventHandler);
        }
    }

    protected EventLoggerEventHandler getEventHandler(FlowableEvent event) {
        Class<? extends EventLoggerEventHandler> eventHandlerClass = null;
        if (event.getType().equals(FlowableEngineEventType.ENTITY_INITIALIZED)) {
            ExecutionEntity executionEntity;
            Object entity = ((FlowableEntityEvent)event).getEntity();
            if (entity instanceof ExecutionEntity && (executionEntity = (ExecutionEntity)entity).getProcessInstanceId().equals(executionEntity.getId())) {
                eventHandlerClass = ProcessInstanceStartedEventHandler.class;
            }
        } else if (event.getType().equals(FlowableEngineEventType.ENTITY_DELETED)) {
            ExecutionEntity executionEntity;
            Object entity = ((FlowableEntityEvent)event).getEntity();
            if (entity instanceof ExecutionEntity && (executionEntity = (ExecutionEntity)entity).getProcessInstanceId().equals(executionEntity.getId())) {
                eventHandlerClass = ProcessInstanceEndedEventHandler.class;
            }
        } else {
            eventHandlerClass = this.eventHandlers.get(event.getType());
        }
        if (eventHandlerClass != null) {
            return this.instantiateEventHandler(event, eventHandlerClass);
        }
        return null;
    }

    protected EventLoggerEventHandler instantiateEventHandler(FlowableEvent event, Class<? extends EventLoggerEventHandler> eventHandlerClass) {
        try {
            EventLoggerEventHandler eventHandler = eventHandlerClass.newInstance();
            eventHandler.setTimeStamp(this.clock.getCurrentTime());
            eventHandler.setEvent(event);
            eventHandler.setObjectMapper(this.objectMapper);
            return eventHandler;
        }
        catch (Exception e) {
            LOGGER.warn("Could not instantiate {}, this is most likely a programmatic error", eventHandlerClass);
            return null;
        }
    }

    public boolean isFailOnException() {
        return false;
    }

    public void addEventHandler(FlowableEngineEventType eventType, Class<? extends EventLoggerEventHandler> eventHandlerClass) {
        this.eventHandlers.put(eventType, eventHandlerClass);
    }

    public void addEventLoggerListener(EventLoggerListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<EventLoggerListener>(1);
        }
        this.listeners.add(listener);
    }

    protected EventFlusher createEventFlusher() {
        return null;
    }

    public Clock getClock() {
        return this.clock;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public List<EventLoggerListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<EventLoggerListener> listeners) {
        this.listeners = listeners;
    }
}

