/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;

public class ExecutionGraphUtil {
    public static List<ExecutionEntity> orderFromRootToLeaf(Collection<ExecutionEntity> executions) {
        ArrayList<ExecutionEntity> orderedList = new ArrayList<ExecutionEntity>(executions.size());
        HashSet<String> previousIds = new HashSet<String>();
        for (ExecutionEntity execution : executions) {
            if (execution.getParentId() != null) continue;
            orderedList.add(execution);
            previousIds.add(execution.getId());
        }
        while (orderedList.size() < executions.size()) {
            for (ExecutionEntity execution : executions) {
                if (previousIds.contains(execution.getId()) || !previousIds.contains(execution.getParentId())) continue;
                orderedList.add(execution);
                previousIds.add(execution.getId());
            }
        }
        return orderedList;
    }

    public static List<ExecutionEntity> orderFromLeafToRoot(Collection<ExecutionEntity> executions) {
        List<ExecutionEntity> orderedList = ExecutionGraphUtil.orderFromRootToLeaf(executions);
        Collections.reverse(orderedList);
        return orderedList;
    }

    public static boolean isReachable(String processDefinitionId, String sourceElementId, String targetElementId) {
        Process process = ProcessDefinitionUtil.getProcess(processDefinitionId);
        FlowElement sourceFlowElement = process.getFlowElement(sourceElementId, true);
        FlowNode sourceElement = null;
        if (sourceFlowElement instanceof FlowNode) {
            sourceElement = (FlowNode)sourceFlowElement;
        } else if (sourceFlowElement instanceof SequenceFlow) {
            sourceElement = (FlowNode)((SequenceFlow)sourceFlowElement).getTargetFlowElement();
        }
        FlowElement targetFlowElement = process.getFlowElement(targetElementId, true);
        FlowNode targetElement = null;
        if (targetFlowElement instanceof FlowNode) {
            targetElement = (FlowNode)targetFlowElement;
        } else if (targetFlowElement instanceof SequenceFlow) {
            targetElement = (FlowNode)((SequenceFlow)targetFlowElement).getTargetFlowElement();
        }
        if (sourceElement == null) {
            throw new FlowableException("Invalid sourceElementId '" + sourceElementId + "': no element found for this id n process definition '" + processDefinitionId + "'");
        }
        if (targetElement == null) {
            throw new FlowableException("Invalid targetElementId '" + targetElementId + "': no element found for this id n process definition '" + processDefinitionId + "'");
        }
        HashSet<String> visitedElements = new HashSet<String>();
        return ExecutionGraphUtil.isReachable(process, sourceElement, targetElement, visitedElements);
    }

    public static boolean isReachable(Process process, FlowNode sourceElement, FlowNode targetElement, Set<String> visitedElements) {
        if (sourceElement instanceof StartEvent && ExecutionGraphUtil.isInEventSubprocess(sourceElement)) {
            return false;
        }
        if (sourceElement.getOutgoingFlows().size() == 0) {
            visitedElements.add(sourceElement.getId());
            FlowElementsContainer parentElement = process.findParent((FlowElement)sourceElement);
            if (parentElement instanceof SubProcess) {
                sourceElement = (SubProcess)parentElement;
            } else {
                return false;
            }
        }
        if (sourceElement.getId().equals(targetElement.getId())) {
            return true;
        }
        visitedElements.add(sourceElement.getId());
        List sequenceFlows = sourceElement.getOutgoingFlows();
        if (sequenceFlows != null && sequenceFlows.size() > 0) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                boolean reachable;
                String targetRef = sequenceFlow.getTargetRef();
                FlowNode sequenceFlowTarget = (FlowNode)process.getFlowElement(targetRef, true);
                if (sequenceFlowTarget == null || visitedElements.contains(sequenceFlowTarget.getId()) || !(reachable = ExecutionGraphUtil.isReachable(process, sequenceFlowTarget, targetElement, visitedElements))) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isInEventSubprocess(FlowNode flowNode) {
        FlowElementsContainer flowElementsContainer = flowNode.getParentContainer();
        while (flowElementsContainer != null) {
            if (flowElementsContainer instanceof EventSubProcess) {
                return true;
            }
            if (flowElementsContainer instanceof FlowElement) {
                flowElementsContainer = ((FlowElement)flowElementsContainer).getParentContainer();
                continue;
            }
            flowElementsContainer = null;
        }
        return false;
    }
}

