/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricDetailEntityManager;
import org.flowable.engine.impl.persistence.entity.HistoricFormPropertyEntity;
import org.flowable.engine.impl.persistence.entity.data.HistoricDetailDataManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;

public class FormPropertiesSubmittedHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    @Override
    public String getType() {
        return "form-properties-submitted";
    }

    @Override
    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        HistoricActivityInstanceEntity activityInstance;
        String activityId = this.getStringFromJson(historicalData, "activityId");
        return !StringUtils.isNotEmpty((CharSequence)activityId) || (activityInstance = this.findHistoricActivityInstance(commandContext, this.getStringFromJson(historicalData, "executionId"), activityId)) != null;
    }

    @Override
    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String propertyId;
        HistoricDetailDataManager historicDetailDataManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getHistoricDetailDataManager();
        boolean hasMoreFormProperties = true;
        int counter = 1;
        while (hasMoreFormProperties && !StringUtils.isEmpty((CharSequence)(propertyId = this.getStringFromJson(historicalData, "formPropertyId" + counter)))) {
            HistoricFormPropertyEntity historicFormPropertyEntity = historicDetailDataManager.createHistoricFormProperty();
            historicFormPropertyEntity.setProcessInstanceId(this.getStringFromJson(historicalData, "processInstanceId"));
            historicFormPropertyEntity.setExecutionId(this.getStringFromJson(historicalData, "executionId"));
            historicFormPropertyEntity.setTaskId(this.getStringFromJson(historicalData, "taskId"));
            historicFormPropertyEntity.setPropertyId(propertyId);
            historicFormPropertyEntity.setPropertyValue(this.getStringFromJson(historicalData, "formPropertyValue" + counter));
            historicFormPropertyEntity.setTime(this.getDateFromJson(historicalData, "createTime"));
            String activityId = this.getStringFromJson(historicalData, "activityId");
            if (StringUtils.isNotEmpty((CharSequence)activityId)) {
                HistoricActivityInstanceEntity activityInstance = this.findHistoricActivityInstance(commandContext, this.getStringFromJson(historicalData, "executionId"), activityId);
                historicFormPropertyEntity.setActivityInstanceId(activityInstance.getId());
            }
            HistoricDetailEntityManager historicDetailEntityManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getHistoricDetailEntityManager();
            historicDetailEntityManager.insert(historicFormPropertyEntity);
            ++counter;
        }
    }
}

