/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.delegate.event;

import org.flowable.engine.common.api.delegate.event.FlowableEngineEventType;
import org.flowable.engine.common.api.delegate.event.FlowableEntityEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEventListener;

public class BaseEntityEventListener
implements FlowableEventListener {
    protected boolean failOnException;
    protected Class<?> entityClass;

    public BaseEntityEventListener() {
        this(true, null);
    }

    public BaseEntityEventListener(boolean failOnException) {
        this(failOnException, null);
    }

    public BaseEntityEventListener(boolean failOnException, Class<?> entityClass) {
        this.failOnException = failOnException;
        this.entityClass = entityClass;
    }

    public final void onEvent(FlowableEvent event) {
        if (this.isValidEvent(event)) {
            if (event.getType() == FlowableEngineEventType.ENTITY_CREATED) {
                this.onCreate(event);
            } else if (event.getType() == FlowableEngineEventType.ENTITY_INITIALIZED) {
                this.onInitialized(event);
            } else if (event.getType() == FlowableEngineEventType.ENTITY_DELETED) {
                this.onDelete(event);
            } else if (event.getType() == FlowableEngineEventType.ENTITY_UPDATED) {
                this.onUpdate(event);
            } else {
                this.onEntityEvent(event);
            }
        }
    }

    public boolean isFailOnException() {
        return this.failOnException;
    }

    protected boolean isValidEvent(FlowableEvent event) {
        boolean valid = false;
        if (event instanceof FlowableEntityEvent) {
            valid = this.entityClass == null ? true : this.entityClass.isAssignableFrom(((FlowableEntityEvent)event).getEntity().getClass());
        }
        return valid;
    }

    protected void onCreate(FlowableEvent event) {
    }

    protected void onInitialized(FlowableEvent event) {
    }

    protected void onDelete(FlowableEvent event) {
    }

    protected void onUpdate(FlowableEvent event) {
    }

    protected void onEntityEvent(FlowableEvent event) {
    }
}

