/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.delegate.event;

import java.util.Set;
import org.flowable.engine.common.api.delegate.event.FlowableEngineEntityEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEngineEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEngineEventType;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEventListener;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.FlowableActivityCancelledEvent;
import org.flowable.engine.delegate.event.FlowableActivityEvent;
import org.flowable.engine.delegate.event.FlowableCancelledEvent;
import org.flowable.engine.delegate.event.FlowableErrorEvent;
import org.flowable.engine.delegate.event.FlowableMessageEvent;
import org.flowable.engine.delegate.event.FlowableProcessEngineEvent;
import org.flowable.engine.delegate.event.FlowableProcessStartedEvent;
import org.flowable.engine.delegate.event.FlowableSequenceFlowTakenEvent;
import org.flowable.engine.delegate.event.FlowableSignalEvent;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.variable.api.event.FlowableVariableEvent;

public abstract class AbstractFlowableEngineEventListener
implements FlowableEventListener {
    protected Set<FlowableEngineEventType> types;

    public AbstractFlowableEngineEventListener() {
    }

    public AbstractFlowableEngineEventListener(Set<FlowableEngineEventType> types) {
        this.types = types;
    }

    public void onEvent(FlowableEvent flowableEvent) {
        if (flowableEvent instanceof FlowableEngineEvent) {
            FlowableEngineEvent flowableEngineEvent = (FlowableEngineEvent)flowableEvent;
            FlowableEngineEventType engineEventType = (FlowableEngineEventType)flowableEvent.getType();
            if (this.types == null || this.types.contains(engineEventType)) {
                switch (engineEventType) {
                    case ENTITY_CREATED: {
                        this.entityCreated((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case ENTITY_INITIALIZED: {
                        this.entityInitialized((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case ENTITY_UPDATED: {
                        this.entityUpdated((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case ENTITY_DELETED: {
                        this.entityDeleted((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case ENTITY_SUSPENDED: {
                        this.entitySuspended((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case ENTITY_ACTIVATED: {
                        this.entityActivated((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case TIMER_SCHEDULED: {
                        this.timerScheduled((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case TIMER_FIRED: {
                        this.timerFired((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case JOB_CANCELED: {
                        this.jobCancelled((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case JOB_EXECUTION_SUCCESS: {
                        this.jobExecutionSuccess((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case JOB_EXECUTION_FAILURE: {
                        this.jobExecutionFailure((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case JOB_RETRIES_DECREMENTED: {
                        this.jobRetriesDecremented((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case JOB_RESCHEDULED: {
                        this.jobRescheduled((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case CUSTOM: {
                        this.custom(flowableEngineEvent);
                        break;
                    }
                    case ENGINE_CREATED: {
                        this.engineCreated((FlowableProcessEngineEvent)flowableEngineEvent);
                        break;
                    }
                    case ENGINE_CLOSED: {
                        this.engineClosed((FlowableProcessEngineEvent)flowableEngineEvent);
                        break;
                    }
                    case ACTIVITY_STARTED: {
                        this.activityStarted((FlowableActivityEvent)flowableEngineEvent);
                        break;
                    }
                    case ACTIVITY_COMPLETED: {
                        this.activityCompleted((FlowableActivityEvent)flowableEngineEvent);
                        break;
                    }
                    case ACTIVITY_CANCELLED: {
                        this.activityCancelled((FlowableActivityCancelledEvent)flowableEngineEvent);
                        break;
                    }
                    case ACTIVITY_SIGNAL_WAITING: {
                        this.activitySignalWaiting((FlowableSignalEvent)flowableEngineEvent);
                        break;
                    }
                    case ACTIVITY_SIGNALED: {
                        this.activitySignaled((FlowableSignalEvent)flowableEngineEvent);
                        break;
                    }
                    case ACTIVITY_COMPENSATE: {
                        this.activityCompensate((FlowableActivityEvent)flowableEngineEvent);
                        break;
                    }
                    case ACTIVITY_MESSAGE_WAITING: {
                        this.activityMessageWaiting((FlowableMessageEvent)flowableEngineEvent);
                        break;
                    }
                    case ACTIVITY_MESSAGE_RECEIVED: {
                        this.activityMessageReceived((FlowableMessageEvent)flowableEngineEvent);
                        break;
                    }
                    case ACTIVITY_MESSAGE_CANCELLED: {
                        this.activityMessageCancelled((FlowableMessageEvent)flowableEngineEvent);
                        break;
                    }
                    case ACTIVITY_ERROR_RECEIVED: {
                        this.activityErrorReceived((FlowableErrorEvent)flowableEngineEvent);
                        break;
                    }
                    case HISTORIC_ACTIVITY_INSTANCE_CREATED: {
                        this.historicActivityInstanceCreated((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case HISTORIC_ACTIVITY_INSTANCE_ENDED: {
                        this.historicActivityInstanceEnded((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case SEQUENCEFLOW_TAKEN: {
                        this.sequenceFlowTaken((FlowableSequenceFlowTakenEvent)flowableEngineEvent);
                        break;
                    }
                    case VARIABLE_CREATED: {
                        this.variableCreated((FlowableVariableEvent)flowableEngineEvent);
                        break;
                    }
                    case VARIABLE_UPDATED: {
                        this.variableUpdatedEvent((FlowableVariableEvent)flowableEngineEvent);
                        break;
                    }
                    case VARIABLE_DELETED: {
                        this.variableDeletedEvent((FlowableVariableEvent)flowableEngineEvent);
                        break;
                    }
                    case TASK_CREATED: {
                        this.taskCreated((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case TASK_ASSIGNED: {
                        this.taskAssigned((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case TASK_COMPLETED: {
                        this.taskCompleted((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case PROCESS_CREATED: {
                        this.processCreated((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case PROCESS_STARTED: {
                        this.processStarted((FlowableProcessStartedEvent)flowableEngineEvent);
                        break;
                    }
                    case PROCESS_COMPLETED: {
                        this.processCompleted((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case PROCESS_COMPLETED_WITH_TERMINATE_END_EVENT: {
                        this.processCompletedWithTerminateEnd((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case PROCESS_COMPLETED_WITH_ERROR_END_EVENT: {
                        this.processCompletedWithErrorEnd((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case PROCESS_CANCELLED: {
                        this.processCancelled((FlowableCancelledEvent)flowableEngineEvent);
                        break;
                    }
                    case HISTORIC_PROCESS_INSTANCE_CREATED: {
                        this.historicProcessInstanceCreated((FlowableEngineEntityEvent)flowableEngineEvent);
                        break;
                    }
                    case HISTORIC_PROCESS_INSTANCE_ENDED: {
                        this.historicProcessInstanceEnded((FlowableEngineEntityEvent)flowableEngineEvent);
                    }
                }
            }
        }
    }

    public boolean isFailOnException() {
        return true;
    }

    protected void entityCreated(FlowableEngineEntityEvent event) {
    }

    protected void entityInitialized(FlowableEngineEntityEvent event) {
    }

    protected void entityUpdated(FlowableEngineEntityEvent event) {
    }

    protected void entityDeleted(FlowableEngineEntityEvent event) {
    }

    protected void entitySuspended(FlowableEngineEntityEvent event) {
    }

    protected void entityActivated(FlowableEngineEntityEvent event) {
    }

    protected void timerScheduled(FlowableEngineEntityEvent event) {
    }

    protected void timerFired(FlowableEngineEntityEvent event) {
    }

    protected void jobCancelled(FlowableEngineEntityEvent event) {
    }

    protected void jobExecutionSuccess(FlowableEngineEntityEvent event) {
    }

    protected void jobExecutionFailure(FlowableEngineEntityEvent event) {
    }

    protected void jobRetriesDecremented(FlowableEngineEntityEvent event) {
    }

    protected void jobRescheduled(FlowableEngineEntityEvent event) {
    }

    protected void custom(FlowableEngineEvent event) {
    }

    protected void engineCreated(FlowableProcessEngineEvent event) {
    }

    protected void engineClosed(FlowableProcessEngineEvent flowableEngineEvent) {
    }

    protected void activityStarted(FlowableActivityEvent event) {
    }

    protected void activityCompleted(FlowableActivityEvent event) {
    }

    protected void activityCancelled(FlowableActivityCancelledEvent event) {
    }

    protected void activitySignalWaiting(FlowableSignalEvent event) {
    }

    protected void activitySignaled(FlowableSignalEvent event) {
    }

    protected void activityCompensate(FlowableActivityEvent event) {
    }

    protected void activityMessageWaiting(FlowableMessageEvent event) {
    }

    protected void activityMessageReceived(FlowableMessageEvent event) {
    }

    protected void activityMessageCancelled(FlowableMessageEvent event) {
    }

    protected void activityErrorReceived(FlowableErrorEvent event) {
    }

    protected void historicActivityInstanceCreated(FlowableEngineEntityEvent event) {
    }

    protected void historicActivityInstanceEnded(FlowableEngineEntityEvent event) {
    }

    protected void sequenceFlowTaken(FlowableSequenceFlowTakenEvent event) {
    }

    protected void variableCreated(FlowableVariableEvent event) {
    }

    protected void variableUpdatedEvent(FlowableVariableEvent event) {
    }

    protected void variableDeletedEvent(FlowableVariableEvent event) {
    }

    protected void taskCreated(FlowableEngineEntityEvent event) {
    }

    protected void taskAssigned(FlowableEngineEntityEvent event) {
    }

    protected void taskCompleted(FlowableEngineEntityEvent event) {
    }

    protected void processCreated(FlowableEngineEntityEvent event) {
    }

    protected void processStarted(FlowableProcessStartedEvent event) {
    }

    protected void processCompleted(FlowableEngineEntityEvent event) {
    }

    protected void processCompletedWithTerminateEnd(FlowableEngineEntityEvent event) {
    }

    protected void processCompletedWithErrorEnd(FlowableEngineEntityEvent event) {
    }

    protected void processCancelled(FlowableCancelledEvent event) {
    }

    protected void historicProcessInstanceCreated(FlowableEngineEntityEvent event) {
    }

    protected void historicProcessInstanceEnded(FlowableEngineEntityEvent event) {
    }

    protected DelegateExecution getExecution(FlowableEngineEvent event) {
        CommandContext commandContext;
        String executionId = event.getExecutionId();
        if (executionId != null && (commandContext = CommandContextUtil.getCommandContext()) != null) {
            return (DelegateExecution)CommandContextUtil.getExecutionEntityManager(commandContext).findById(executionId);
        }
        return null;
    }
}

