/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import junit.framework.AssertionFailedError;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.DynamicBpmnService;
import org.flowable.engine.FormService;
import org.flowable.engine.HistoryService;
import org.flowable.engine.IdentityService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.common.impl.db.DbSchemaManager;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.interceptor.CommandExecutor;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.history.HistoricTaskInstance;
import org.flowable.engine.history.HistoricTaskInstanceQuery;
import org.flowable.engine.impl.ProcessEngineImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.DefaultHistoryManager;
import org.flowable.engine.impl.history.HistoryLevel;
import org.flowable.engine.impl.history.HistoryManager;
import org.flowable.engine.impl.test.AbstractTestCase;
import org.flowable.engine.impl.test.HistoryTestHelper;
import org.flowable.engine.impl.test.JobTestHelper;
import org.flowable.engine.impl.test.TestHelper;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.HistoryJob;
import org.flowable.engine.runtime.ProcessInstance;
import org.junit.Assert;

public abstract class AbstractFlowableTestCase
extends AbstractTestCase {
    private static final List<String> TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK = new ArrayList<String>();
    protected ProcessEngine processEngine;
    protected String deploymentIdFromDeploymentAnnotation;
    protected List<String> deploymentIdsForAutoCleanup = new ArrayList<String>();
    protected Throwable exception;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected FormService formService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    protected DynamicBpmnService dynamicBpmnService;

    protected void setUp() throws Exception {
        super.setUp();
        this.identityService.setAuthenticatedUserId(null);
    }

    protected abstract void initializeProcessEngine();

    protected void closeDownProcessEngine() {
    }

    protected void nullifyServices() {
        this.processEngineConfiguration = null;
        this.repositoryService = null;
        this.runtimeService = null;
        this.taskService = null;
        this.formService = null;
        this.historyService = null;
        this.identityService = null;
        this.managementService = null;
        this.dynamicBpmnService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        this.initializeProcessEngine();
        this.initializeServices();
        try {
            this.deploymentIdFromDeploymentAnnotation = TestHelper.annotationDeploymentSetUp(this.processEngine, ((Object)((Object)this)).getClass(), this.getName());
            super.runBare();
            this.validateHistoryData();
        }
        catch (AssertionFailedError e) {
            LOGGER.error("\n");
            LOGGER.error("ASSERTION FAILED: {}", (Object)e, (Object)e);
            this.exception = e;
            throw e;
        }
        catch (Throwable e) {
            LOGGER.error("\n");
            LOGGER.error("EXCEPTION: {}", (Object)e, (Object)e);
            this.exception = e;
            throw e;
        }
        finally {
            boolean isAsyncHistoryEnabled = this.processEngineConfiguration.isAsyncHistoryEnabled();
            if (isAsyncHistoryEnabled) {
                List jobs = this.managementService.createHistoryJobQuery().list();
                for (HistoryJob job : jobs) {
                    this.managementService.deleteHistoryJob(job.getId());
                }
            }
            HistoryManager asyncHistoryManager = null;
            try {
                if (isAsyncHistoryEnabled) {
                    this.processEngineConfiguration.setAsyncHistoryEnabled(false);
                    asyncHistoryManager = this.processEngineConfiguration.getHistoryManager();
                    this.processEngineConfiguration.setHistoryManager(new DefaultHistoryManager(this.processEngineConfiguration, this.processEngineConfiguration.getHistoryLevel()));
                }
                if (this.deploymentIdFromDeploymentAnnotation != null) {
                    TestHelper.annotationDeploymentTearDown(this.processEngine, this.deploymentIdFromDeploymentAnnotation, ((Object)((Object)this)).getClass(), this.getName());
                    this.deploymentIdFromDeploymentAnnotation = null;
                }
                for (String autoDeletedDeploymentId : this.deploymentIdsForAutoCleanup) {
                    this.repositoryService.deleteDeployment(autoDeletedDeploymentId, true);
                }
                this.deploymentIdsForAutoCleanup.clear();
                this.assertAndEnsureCleanDb();
            }
            finally {
                if (isAsyncHistoryEnabled) {
                    this.processEngineConfiguration.setAsyncHistoryEnabled(true);
                    this.processEngineConfiguration.setHistoryManager(asyncHistoryManager);
                }
                this.processEngineConfiguration.getClock().reset();
            }
            this.closeDownProcessEngine();
        }
    }

    protected void validateHistoryData() {
        if (this.processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().finished().list();
            for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
                List historicActivityInstances;
                AbstractFlowableTestCase.assertNotNull((String)"Historic process instance has no process definition id", (Object)historicProcessInstance.getProcessDefinitionId());
                AbstractFlowableTestCase.assertNotNull((String)"Historic process instance has no process definition key", (Object)historicProcessInstance.getProcessDefinitionKey());
                AbstractFlowableTestCase.assertNotNull((String)"Historic process instance has no process definition version", (Object)historicProcessInstance.getProcessDefinitionVersion());
                AbstractFlowableTestCase.assertNotNull((String)"Historic process instance has no deployment id", (Object)historicProcessInstance.getDeploymentId());
                AbstractFlowableTestCase.assertNotNull((String)"Historic process instance has no start activity id", (Object)historicProcessInstance.getStartActivityId());
                AbstractFlowableTestCase.assertNotNull((String)"Historic process instance has no start time", (Object)historicProcessInstance.getStartTime());
                AbstractFlowableTestCase.assertNotNull((String)"Historic process instance has no end time", (Object)historicProcessInstance.getEndTime());
                String processInstanceId = historicProcessInstance.getId();
                List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).list();
                if (historicTaskInstances != null && historicTaskInstances.size() > 0) {
                    for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
                        AbstractFlowableTestCase.assertEquals((String)processInstanceId, (String)historicTaskInstance.getProcessInstanceId());
                        if (historicTaskInstance.getClaimTime() != null) {
                            AbstractFlowableTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no work time"), (Object)historicTaskInstance.getWorkTimeInMillis());
                        }
                        AbstractFlowableTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no id"), (Object)historicTaskInstance.getId());
                        AbstractFlowableTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no process instance id"), (Object)historicTaskInstance.getProcessInstanceId());
                        AbstractFlowableTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no execution id"), (Object)historicTaskInstance.getExecutionId());
                        AbstractFlowableTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no process definition id"), (Object)historicTaskInstance.getProcessDefinitionId());
                        AbstractFlowableTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no task definition key"), (Object)historicTaskInstance.getTaskDefinitionKey());
                        AbstractFlowableTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no create time"), (Object)historicTaskInstance.getCreateTime());
                        AbstractFlowableTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no start time"), (Object)historicTaskInstance.getStartTime());
                        AbstractFlowableTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no end time"), (Object)historicTaskInstance.getEndTime());
                    }
                }
                if ((historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list()) == null || historicActivityInstances.size() <= 0) continue;
                for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                    AbstractFlowableTestCase.assertEquals((String)processInstanceId, (String)historicActivityInstance.getProcessInstanceId());
                    AbstractFlowableTestCase.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getId() + " / " + historicActivityInstance.getActivityId() + " has no activity id"), (Object)historicActivityInstance.getActivityId());
                    AbstractFlowableTestCase.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getId() + " / " + historicActivityInstance.getActivityId() + " has no activity type"), (Object)historicActivityInstance.getActivityType());
                    AbstractFlowableTestCase.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getId() + " / " + historicActivityInstance.getActivityId() + " has no process definition id"), (Object)historicActivityInstance.getProcessDefinitionId());
                    AbstractFlowableTestCase.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getId() + " / " + historicActivityInstance.getActivityId() + " has no process instance id"), (Object)historicActivityInstance.getProcessInstanceId());
                    AbstractFlowableTestCase.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getId() + " / " + historicActivityInstance.getActivityId() + " has no execution id"), (Object)historicActivityInstance.getExecutionId());
                    AbstractFlowableTestCase.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getId() + " / " + historicActivityInstance.getActivityId() + " has no start time"), (Object)historicActivityInstance.getStartTime());
                    AbstractFlowableTestCase.assertNotNull((String)("Historic activity instance " + historicActivityInstance.getId() + " / " + historicActivityInstance.getActivityId() + " has no end time"), (Object)historicActivityInstance.getEndTime());
                }
            }
        }
    }

    protected void assertAndEnsureCleanDb() throws Throwable {
        LOGGER.debug("verifying that db is clean after test");
        Map<String, Long> tableCounts = this.managementService.getTableCount();
        StringBuilder outputMessage = new StringBuilder();
        for (String tableName : tableCounts.keySet()) {
            Long count;
            String tableNameWithoutPrefix = tableName.replace(this.processEngineConfiguration.getDatabaseTablePrefix(), "");
            if (TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.contains(tableNameWithoutPrefix) || (count = tableCounts.get(tableName)) == 0L) continue;
            outputMessage.append("  ").append(tableName).append(": ").append(count).append(" record(s) ");
        }
        if (outputMessage.length() > 0) {
            outputMessage.insert(0, "DB NOT CLEAN: \n");
            LOGGER.error("\n");
            LOGGER.error(outputMessage.toString());
            LOGGER.info("dropping and recreating db");
            CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutor();
            CommandConfig config = new CommandConfig().transactionNotSupported();
            commandExecutor.execute(config, (Command)new Command<Object>(){

                public Object execute(CommandContext commandContext) {
                    DbSchemaManager dbSchemaManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getDbSchemaManager();
                    dbSchemaManager.dbSchemaDrop();
                    dbSchemaManager.dbSchemaCreate();
                    return null;
                }
            });
            if (this.exception != null) {
                throw this.exception;
            }
            Assert.fail((String)outputMessage.toString());
        } else {
            LOGGER.info("database was clean");
        }
    }

    protected void initializeServices() {
        this.processEngineConfiguration = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration();
        this.repositoryService = this.processEngine.getRepositoryService();
        this.runtimeService = this.processEngine.getRuntimeService();
        this.taskService = this.processEngine.getTaskService();
        this.formService = this.processEngine.getFormService();
        this.historyService = this.processEngine.getHistoryService();
        this.identityService = this.processEngine.getIdentityService();
        this.managementService = this.processEngine.getManagementService();
        this.dynamicBpmnService = this.processEngine.getDynamicBpmnService();
    }

    public void assertProcessEnded(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance != null) {
            throw new AssertionFailedError("Expected finished process instance '" + processInstanceId + "' but it was still in the db");
        }
        if (HistoryTestHelper.isHistoryLevelAtLeast(HistoryLevel.AUDIT, this.processEngineConfiguration)) {
            List historicActivityInstances;
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            AbstractFlowableTestCase.assertEquals((String)processInstanceId, (String)historicProcessInstance.getId());
            AbstractFlowableTestCase.assertNotNull((String)"Historic process instance has no start time", (Object)historicProcessInstance.getStartTime());
            AbstractFlowableTestCase.assertNotNull((String)"Historic process instance has no end time", (Object)historicProcessInstance.getEndTime());
            List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).list();
            if (historicTaskInstances != null && historicTaskInstances.size() > 0) {
                for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
                    AbstractFlowableTestCase.assertEquals((String)processInstanceId, (String)historicTaskInstance.getProcessInstanceId());
                    AbstractFlowableTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no start time"), (Object)historicTaskInstance.getStartTime());
                    AbstractFlowableTestCase.assertNotNull((String)("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no end time"), (Object)historicTaskInstance.getEndTime());
                }
            }
            if ((historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list()) != null && historicActivityInstances.size() > 0) {
                for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                    AbstractFlowableTestCase.assertEquals((String)processInstanceId, (String)historicActivityInstance.getProcessInstanceId());
                    AbstractFlowableTestCase.assertNotNull((String)(historicActivityInstance.getId() + " Historic activity instance '" + historicActivityInstance.getActivityId() + "' has no start time"), (Object)historicActivityInstance.getStartTime());
                    AbstractFlowableTestCase.assertNotNull((String)(historicActivityInstance.getId() + " Historic activity instance '" + historicActivityInstance.getActivityId() + "' has no end time"), (Object)historicActivityInstance.getEndTime());
                }
            }
        }
    }

    public void waitForJobExecutorToProcessAllJobs(long maxMillisToWait, long intervalMillis) {
        JobTestHelper.waitForJobExecutorToProcessAllJobs(this.processEngineConfiguration, this.managementService, maxMillisToWait, intervalMillis);
    }

    public void waitForJobExecutorOnCondition(long maxMillisToWait, long intervalMillis, Callable<Boolean> condition) {
        JobTestHelper.waitForJobExecutorOnCondition(this.processEngineConfiguration, maxMillisToWait, intervalMillis, condition);
    }

    public void executeJobExecutorForTime(long maxMillisToWait, long intervalMillis) {
        JobTestHelper.executeJobExecutorForTime(this.processEngineConfiguration, maxMillisToWait, intervalMillis);
    }

    public void waitForJobExecutorToProcessAllJobsAndExecutableTimerJobs(long maxMillisToWait, long intervalMillis) {
        JobTestHelper.waitForJobExecutorToProcessAllJobsAndExecutableTimerJobs(this.processEngineConfiguration, this.managementService, maxMillisToWait, intervalMillis);
    }

    public void waitForJobExecutorToProcessAllHistoryJobs(long maxMillisToWait, long intervalMillis) {
        HistoryTestHelper.waitForJobExecutorToProcessAllHistoryJobs(this.processEngineConfiguration, this.managementService, maxMillisToWait, intervalMillis);
    }

    public void waitForHistoryJobExecutorToProcessAllJobs(long maxMillisToWait, long intervalMillis) {
        HistoryTestHelper.waitForJobExecutorToProcessAllHistoryJobs(this.processEngineConfiguration, this.managementService, maxMillisToWait, intervalMillis);
    }

    public BpmnModel createOneTaskTestProcess() {
        BpmnModel model = new BpmnModel();
        Process process = new Process();
        model.addProcess(process);
        process.setId("oneTaskProcess");
        process.setName("The one task process");
        StartEvent startEvent = new StartEvent();
        startEvent.setId("start");
        startEvent.setName("The start");
        process.addFlowElement((FlowElement)startEvent);
        UserTask userTask = new UserTask();
        userTask.setName("The Task");
        userTask.setId("theTask");
        userTask.setAssignee("kermit");
        process.addFlowElement((FlowElement)userTask);
        EndEvent endEvent = new EndEvent();
        endEvent.setId("theEnd");
        endEvent.setName("The end");
        process.addFlowElement((FlowElement)endEvent);
        process.addFlowElement((FlowElement)new SequenceFlow("start", "theTask"));
        process.addFlowElement((FlowElement)new SequenceFlow("theTask", "theEnd"));
        return model;
    }

    public BpmnModel createTwoTasksTestProcess() {
        BpmnModel model = new BpmnModel();
        Process process = new Process();
        model.addProcess(process);
        process.setId("twoTasksProcess");
        process.setName("The two tasks process");
        StartEvent startEvent = new StartEvent();
        startEvent.setId("start");
        process.addFlowElement((FlowElement)startEvent);
        UserTask userTask = new UserTask();
        userTask.setName("The First Task");
        userTask.setId("task1");
        userTask.setAssignee("kermit");
        process.addFlowElement((FlowElement)userTask);
        UserTask userTask2 = new UserTask();
        userTask2.setName("The Second Task");
        userTask2.setId("task2");
        userTask2.setAssignee("kermit");
        process.addFlowElement((FlowElement)userTask2);
        EndEvent endEvent = new EndEvent();
        endEvent.setId("theEnd");
        process.addFlowElement((FlowElement)endEvent);
        process.addFlowElement((FlowElement)new SequenceFlow("start", "task1"));
        process.addFlowElement((FlowElement)new SequenceFlow("start", "task2"));
        process.addFlowElement((FlowElement)new SequenceFlow("task1", "theEnd"));
        process.addFlowElement((FlowElement)new SequenceFlow("task2", "theEnd"));
        return model;
    }

    public String deployOneTaskTestProcess() {
        BpmnModel bpmnModel = this.createOneTaskTestProcess();
        Deployment deployment = this.repositoryService.createDeployment().addBpmnModel("oneTasktest.bpmn20.xml", bpmnModel).deploy();
        this.deploymentIdsForAutoCleanup.add(deployment.getId());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        return processDefinition.getId();
    }

    public String deployTwoTasksTestProcess() {
        BpmnModel bpmnModel = this.createTwoTasksTestProcess();
        Deployment deployment = this.repositoryService.createDeployment().addBpmnModel("twoTasksTestProcess.bpmn20.xml", bpmnModel).deploy();
        this.deploymentIdsForAutoCleanup.add(deployment.getId());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        return processDefinition.getId();
    }

    protected void deleteDeployments() {
        boolean isAsyncHistoryEnabled = this.processEngineConfiguration.isAsyncHistoryEnabled();
        HistoryManager asyncHistoryManager = null;
        if (isAsyncHistoryEnabled) {
            this.processEngineConfiguration.setAsyncHistoryEnabled(false);
            asyncHistoryManager = this.processEngineConfiguration.getHistoryManager();
            this.processEngineConfiguration.setHistoryManager(new DefaultHistoryManager(this.processEngineConfiguration, this.processEngineConfiguration.getHistoryLevel()));
        }
        for (Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
        if (isAsyncHistoryEnabled) {
            this.processEngineConfiguration.setAsyncHistoryEnabled(true);
            this.processEngineConfiguration.setHistoryManager(asyncHistoryManager);
        }
    }

    protected void deleteDeployment(String deploymentId) {
        boolean isAsyncHistoryEnabled = this.processEngineConfiguration.isAsyncHistoryEnabled();
        HistoryManager asyncHistoryManager = null;
        if (isAsyncHistoryEnabled) {
            this.processEngineConfiguration.setAsyncHistoryEnabled(false);
            asyncHistoryManager = this.processEngineConfiguration.getHistoryManager();
            this.processEngineConfiguration.setHistoryManager(new DefaultHistoryManager(this.processEngineConfiguration, this.processEngineConfiguration.getHistoryLevel()));
        }
        this.repositoryService.deleteDeployment(deploymentId, true);
        if (isAsyncHistoryEnabled) {
            this.processEngineConfiguration.setAsyncHistoryEnabled(true);
            this.processEngineConfiguration.setHistoryManager(asyncHistoryManager);
        }
    }

    protected void assertHistoricTasksDeleteReason(ProcessInstance processInstance, String expectedDeleteReason, String ... taskNames) {
        if (this.processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            for (String taskName : taskNames) {
                List historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getId())).taskName(taskName)).list();
                AbstractFlowableTestCase.assertTrue((historicTaskInstances.size() > 0 ? 1 : 0) != 0);
                for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
                    AbstractFlowableTestCase.assertNotNull((Object)historicTaskInstance.getEndTime());
                    if (expectedDeleteReason == null) {
                        AbstractFlowableTestCase.assertNull((Object)historicTaskInstance.getDeleteReason());
                        continue;
                    }
                    AbstractFlowableTestCase.assertTrue((boolean)historicTaskInstance.getDeleteReason().startsWith(expectedDeleteReason));
                }
            }
        }
    }

    protected void assertHistoricActivitiesDeleteReason(ProcessInstance processInstance, String expectedDeleteReason, String ... activityIds) {
        if (this.processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            for (String activityId : activityIds) {
                List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().activityId(activityId).processInstanceId(processInstance.getId()).list();
                AbstractFlowableTestCase.assertTrue((String)"Could not find historic activities", (historicActivityInstances.size() > 0 ? 1 : 0) != 0);
                for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                    AbstractFlowableTestCase.assertNotNull((Object)historicActivityInstance.getEndTime());
                    if (expectedDeleteReason == null) {
                        AbstractFlowableTestCase.assertNull((Object)historicActivityInstance.getDeleteReason());
                        continue;
                    }
                    AbstractFlowableTestCase.assertTrue((boolean)historicActivityInstance.getDeleteReason().startsWith(expectedDeleteReason));
                }
            }
        }
    }

    static {
        TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.add("ACT_GE_PROPERTY");
        TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.add("ACT_ID_PROPERTY");
    }
}

