/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.scripting;

import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import org.flowable.engine.delegate.VariableScope;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.scripting.Resolver;
import org.flowable.engine.impl.scripting.ResolverFactory;
import org.flowable.engine.impl.scripting.ScriptBindings;

public class ScriptBindingsFactory {
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected List<ResolverFactory> resolverFactories;

    public ScriptBindingsFactory(ProcessEngineConfigurationImpl processEngineConfiguration, List<ResolverFactory> resolverFactories) {
        this.processEngineConfiguration = processEngineConfiguration;
        this.resolverFactories = resolverFactories;
    }

    public Bindings createBindings(VariableScope variableScope) {
        return new ScriptBindings(this.createResolvers(variableScope), variableScope);
    }

    public Bindings createBindings(VariableScope variableScope, boolean storeScriptVariables) {
        return new ScriptBindings(this.createResolvers(variableScope), variableScope, storeScriptVariables);
    }

    protected List<Resolver> createResolvers(VariableScope variableScope) {
        ArrayList<Resolver> scriptResolvers = new ArrayList<Resolver>();
        for (ResolverFactory scriptResolverFactory : this.resolverFactories) {
            Resolver resolver = scriptResolverFactory.createResolver(this.processEngineConfiguration, variableScope);
            if (resolver == null) continue;
            scriptResolvers.add(resolver);
        }
        return scriptResolvers;
    }

    public List<ResolverFactory> getResolverFactories() {
        return this.resolverFactories;
    }

    public void setResolverFactories(List<ResolverFactory> resolverFactories) {
        this.resolverFactories = resolverFactories;
    }
}

