/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.flowable.engine.common.impl.persistence.entity.data.DataManager;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.history.HistoricTaskInstance;
import org.flowable.engine.impl.HistoricTaskInstanceQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.HistoryLevel;
import org.flowable.engine.impl.persistence.entity.AbstractEntityManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricTaskInstanceEntityManager;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.impl.persistence.entity.data.HistoricTaskInstanceDataManager;
import org.flowable.engine.impl.util.Flowable5Util;

public class HistoricTaskInstanceEntityManagerImpl
extends AbstractEntityManager<HistoricTaskInstanceEntity>
implements HistoricTaskInstanceEntityManager {
    protected HistoricTaskInstanceDataManager historicTaskInstanceDataManager;

    public HistoricTaskInstanceEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, HistoricTaskInstanceDataManager historicTaskInstanceDataManager) {
        super(processEngineConfiguration);
        this.historicTaskInstanceDataManager = historicTaskInstanceDataManager;
    }

    @Override
    protected DataManager<HistoricTaskInstanceEntity> getDataManager() {
        return this.historicTaskInstanceDataManager;
    }

    @Override
    public HistoricTaskInstanceEntity create(TaskEntity task, ExecutionEntity execution) {
        return this.historicTaskInstanceDataManager.create(task, execution);
    }

    @Override
    public void deleteHistoricTaskInstancesByProcessInstanceId(String processInstanceId) {
        if (this.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            List<HistoricTaskInstanceEntity> taskInstances = this.historicTaskInstanceDataManager.findHistoricTaskInstanceByProcessInstanceId(processInstanceId);
            for (HistoricTaskInstanceEntity historicTaskInstanceEntity : taskInstances) {
                this.delete(historicTaskInstanceEntity.getId());
            }
        }
    }

    @Override
    public long findHistoricTaskInstanceCountByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            return this.historicTaskInstanceDataManager.findHistoricTaskInstanceCountByQueryCriteria(historicTaskInstanceQuery);
        }
        return 0L;
    }

    @Override
    public List<HistoricTaskInstance> findHistoricTaskInstancesByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            return this.historicTaskInstanceDataManager.findHistoricTaskInstancesByQueryCriteria(historicTaskInstanceQuery);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<HistoricTaskInstance> findHistoricTaskInstancesAndRelatedEntitiesByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            return this.historicTaskInstanceDataManager.findHistoricTaskInstancesAndRelatedEntitiesByQueryCriteria(historicTaskInstanceQuery);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void delete(String id) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            this.getCommentEntityManager().deleteCommentsByTaskId(id);
            this.getAttachmentEntityManager().deleteAttachmentsByTaskId(id);
            HistoricTaskInstanceEntity historicTaskInstance = (HistoricTaskInstanceEntity)this.findById(id);
            if (historicTaskInstance != null) {
                if (historicTaskInstance.getProcessDefinitionId() != null && Flowable5Util.isFlowable5ProcessDefinitionId(this.getCommandContext(), historicTaskInstance.getProcessDefinitionId())) {
                    Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                    compatibilityHandler.deleteHistoricTask(id);
                    return;
                }
                List<HistoricTaskInstanceEntity> subTasks = this.historicTaskInstanceDataManager.findHistoricTasksByParentTaskId(historicTaskInstance.getId());
                for (HistoricTaskInstance historicTaskInstance2 : subTasks) {
                    this.delete(historicTaskInstance2.getId());
                }
                this.getHistoricDetailEntityManager().deleteHistoricDetailsByTaskId(id);
                this.getHistoricVariableInstanceEntityManager().deleteHistoricVariableInstancesByTaskId(id);
                this.getHistoricIdentityLinkEntityManager().deleteHistoricIdentityLinksByTaskId(id);
                this.delete(historicTaskInstance);
            }
        }
    }

    @Override
    public List<HistoricTaskInstance> findHistoricTaskInstancesByNativeQuery(Map<String, Object> parameterMap) {
        return this.historicTaskInstanceDataManager.findHistoricTaskInstancesByNativeQuery(parameterMap);
    }

    @Override
    public long findHistoricTaskInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return this.historicTaskInstanceDataManager.findHistoricTaskInstanceCountByNativeQuery(parameterMap);
    }

    public HistoricTaskInstanceDataManager getHistoricTaskInstanceDataManager() {
        return this.historicTaskInstanceDataManager;
    }

    public void setHistoricTaskInstanceDataManager(HistoricTaskInstanceDataManager historicTaskInstanceDataManager) {
        this.historicTaskInstanceDataManager = historicTaskInstanceDataManager;
    }
}

