/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockExclusiveJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LockExclusiveJobCmd.class);
    protected Job job;

    public LockExclusiveJobCmd(Job job) {
        this.job = job;
    }

    public Object execute(CommandContext commandContext) {
        ExecutionEntity execution;
        if (this.job == null) {
            throw new FlowableIllegalArgumentException("job is null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing lock exclusive job {} {}", (Object)this.job.getId(), (Object)this.job.getExecutionId());
        }
        if (this.job.isExclusive() && this.job.getExecutionId() != null && (execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(this.job.getExecutionId())) != null) {
            CommandContextUtil.getExecutionEntityManager(commandContext).updateProcessInstanceLockTime(execution.getProcessInstanceId());
        }
        return null;
    }
}

