/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.flowable.engine.IdentityService;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.task.IdentityLink;
import org.flowable.idm.api.User;

public class GetPotentialStarterUsersCmd
implements Command<List<User>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public GetPotentialStarterUsersCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public List<User> execute(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)CommandContextUtil.getProcessDefinitionEntityManager(commandContext).findById(this.processDefinitionId);
        if (processDefinition == null) {
            throw new FlowableObjectNotFoundException("Cannot find process definition with id " + this.processDefinitionId, ProcessDefinition.class);
        }
        IdentityService identityService = CommandContextUtil.getProcessEngineConfiguration(commandContext).getIdentityService();
        ArrayList<String> userIds = new ArrayList<String>();
        List<IdentityLinkEntity> identityLinks = processDefinition.getIdentityLinks();
        for (IdentityLink identityLink : identityLinks) {
            if (identityLink.getUserId() == null || identityLink.getUserId().length() <= 0 || userIds.contains(identityLink.getUserId())) continue;
            userIds.add(identityLink.getUserId());
        }
        if (userIds.size() > 0) {
            return identityService.createUserQuery().userIds(userIds).list();
        }
        return new ArrayList<User>();
    }
}

