/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.parser.handler;

import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.flowable.engine.impl.bpmn.parser.BpmnParse;
import org.flowable.engine.impl.bpmn.parser.handler.AbstractFlowNodeBpmnParseHandler;
import org.flowable.engine.impl.el.ExpressionManager;
import org.flowable.engine.impl.util.CommandContextUtil;

public abstract class AbstractActivityBpmnParseHandler<T extends FlowNode>
extends AbstractFlowNodeBpmnParseHandler<T> {
    @Override
    public void parse(BpmnParse bpmnParse, BaseElement element) {
        super.parse(bpmnParse, element);
        if (element instanceof Activity && ((Activity)element).getLoopCharacteristics() != null) {
            this.createMultiInstanceLoopCharacteristics(bpmnParse, (Activity)element);
        }
    }

    protected void createMultiInstanceLoopCharacteristics(BpmnParse bpmnParse, Activity modelActivity) {
        MultiInstanceLoopCharacteristics loopCharacteristics = modelActivity.getLoopCharacteristics();
        MultiInstanceActivityBehavior miActivityBehavior = null;
        miActivityBehavior = loopCharacteristics.isSequential() ? bpmnParse.getActivityBehaviorFactory().createSequentialMultiInstanceBehavior(modelActivity, (AbstractBpmnActivityBehavior)modelActivity.getBehavior()) : bpmnParse.getActivityBehaviorFactory().createParallelMultiInstanceBehavior(modelActivity, (AbstractBpmnActivityBehavior)modelActivity.getBehavior());
        modelActivity.setBehavior((Object)miActivityBehavior);
        ExpressionManager expressionManager = CommandContextUtil.getProcessEngineConfiguration().getExpressionManager();
        if (StringUtils.isNotEmpty((CharSequence)loopCharacteristics.getLoopCardinality())) {
            miActivityBehavior.setLoopCardinalityExpression(expressionManager.createExpression(loopCharacteristics.getLoopCardinality()));
        }
        if (StringUtils.isNotEmpty((CharSequence)loopCharacteristics.getCompletionCondition())) {
            miActivityBehavior.setCompletionConditionExpression(expressionManager.createExpression(loopCharacteristics.getCompletionCondition()));
        }
        if (StringUtils.isNotEmpty((CharSequence)loopCharacteristics.getInputDataItem())) {
            if (loopCharacteristics.getInputDataItem().contains("{")) {
                miActivityBehavior.setCollectionExpression(expressionManager.createExpression(loopCharacteristics.getInputDataItem()));
            } else {
                miActivityBehavior.setCollectionVariable(loopCharacteristics.getInputDataItem());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)loopCharacteristics.getElementVariable())) {
            miActivityBehavior.setCollectionElementVariable(loopCharacteristics.getElementVariable());
        }
        if (StringUtils.isNotEmpty((CharSequence)loopCharacteristics.getElementIndexVariable())) {
            miActivityBehavior.setCollectionElementIndexVariable(loopCharacteristics.getElementIndexVariable());
        }
    }
}

