/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.MapExceptionEntry;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.Expression;
import org.flowable.engine.delegate.JavaDelegate;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.DelegateExpressionUtil;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.flowable.engine.impl.bpmn.parser.FieldDeclaration;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.delegate.ActivityBehaviorInvocation;
import org.flowable.engine.impl.delegate.TriggerableActivityBehavior;
import org.flowable.engine.impl.delegate.invocation.JavaDelegateInvocation;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public class ServiceTaskDelegateExpressionActivityBehavior
extends TaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected String serviceTaskId;
    protected Expression expression;
    protected Expression skipExpression;
    protected List<FieldDeclaration> fieldDeclarations;
    protected List<MapExceptionEntry> mapExceptions;

    public ServiceTaskDelegateExpressionActivityBehavior(String serviceTaskId, Expression expression, Expression skipExpression, List<FieldDeclaration> fieldDeclarations, List<MapExceptionEntry> mapExceptions) {
        this.serviceTaskId = serviceTaskId;
        this.expression = expression;
        this.skipExpression = skipExpression;
        this.fieldDeclarations = fieldDeclarations;
        this.mapExceptions = mapExceptions;
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        Object delegate = DelegateExpressionUtil.resolveDelegateExpression(this.expression, execution, this.fieldDeclarations);
        if (delegate instanceof TriggerableActivityBehavior) {
            ((TriggerableActivityBehavior)delegate).trigger(execution, signalName, signalData);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(DelegateExecution execution) {
        try {
            boolean isSkipExpressionEnabled = SkipExpressionUtil.isSkipExpressionEnabled(execution, this.skipExpression);
            if (!isSkipExpressionEnabled || isSkipExpressionEnabled && !SkipExpressionUtil.shouldSkipFlowElement(execution, this.skipExpression)) {
                Object object;
                String overrideExpression;
                ObjectNode objectNode;
                if (CommandContextUtil.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache() && (objectNode = BpmnOverrideContext.getBpmnOverrideElementProperties(this.serviceTaskId, execution.getProcessDefinitionId())) != null && objectNode.has("serviceTaskDelegateExpression") && StringUtils.isNotEmpty((CharSequence)(overrideExpression = objectNode.get("serviceTaskDelegateExpression").asText())) && !overrideExpression.equals(this.expression.getExpressionText())) {
                    this.expression = CommandContextUtil.getProcessEngineConfiguration().getExpressionManager().createExpression(overrideExpression);
                }
                if ((object = DelegateExpressionUtil.resolveDelegateExpression(this.expression, execution, this.fieldDeclarations)) instanceof ActivityBehavior) {
                    if (object instanceof AbstractBpmnActivityBehavior) {
                        ((AbstractBpmnActivityBehavior)object).setMultiInstanceActivityBehavior(this.getMultiInstanceActivityBehavior());
                    }
                    CommandContextUtil.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ActivityBehaviorInvocation((ActivityBehavior)object, execution));
                    return;
                } else {
                    if (!(object instanceof JavaDelegate)) throw new FlowableIllegalArgumentException("Delegate expression " + this.expression + " did neither resolve to an implementation of " + ActivityBehavior.class + " nor " + JavaDelegate.class);
                    CommandContextUtil.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new JavaDelegateInvocation((JavaDelegate)object, execution));
                    this.leave(execution);
                }
                return;
            } else {
                this.leave(execution);
            }
            return;
        }
        catch (Exception exc) {
            void var3_7;
            Exception exception = exc;
            BpmnError error = null;
            while (var3_7 != null) {
                if (var3_7 instanceof BpmnError) {
                    error = (BpmnError)var3_7;
                    break;
                }
                if (var3_7 instanceof RuntimeException && ErrorPropagation.mapException((RuntimeException)var3_7, (ExecutionEntity)execution, this.mapExceptions)) {
                    return;
                }
                Throwable throwable = var3_7.getCause();
            }
            if (error == null) throw new FlowableException(exc.getMessage(), (Throwable)exc);
            ErrorPropagation.propagateError(error, execution);
            return;
        }
    }
}

