/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.interceptor.CommandExecutor;
import org.flowable.engine.impl.AbstractQuery;
import org.flowable.engine.impl.JobQueryProperty;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.runtime.HistoryJob;
import org.flowable.engine.runtime.HistoryJobQuery;

public class HistoryJobQueryImpl
extends AbstractQuery<HistoryJobQuery, HistoryJob>
implements HistoryJobQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String handlerType;
    protected boolean retriesLeft;
    protected boolean withException;
    protected String exceptionMessage;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected boolean noRetriesLeft;
    protected String lockOwner;
    protected boolean onlyLocked;
    protected boolean onlyUnlocked;

    public HistoryJobQueryImpl() {
    }

    public HistoryJobQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public HistoryJobQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public HistoryJobQuery jobId(String jobId) {
        if (jobId == null) {
            throw new FlowableIllegalArgumentException("Provided job id is null");
        }
        this.id = jobId;
        return this;
    }

    @Override
    public HistoryJobQuery handlerType(String handlerType) {
        if (handlerType == null) {
            throw new FlowableIllegalArgumentException("Provided handlerType is null");
        }
        this.handlerType = handlerType;
        return this;
    }

    public HistoryJobQuery withRetriesLeft() {
        this.retriesLeft = true;
        return this;
    }

    public HistoryJobQuery noRetriesLeft() {
        this.noRetriesLeft = true;
        return this;
    }

    @Override
    public HistoryJobQuery withException() {
        this.withException = true;
        return this;
    }

    @Override
    public HistoryJobQuery exceptionMessage(String exceptionMessage) {
        if (exceptionMessage == null) {
            throw new FlowableIllegalArgumentException("Provided exception message is null");
        }
        this.exceptionMessage = exceptionMessage;
        return this;
    }

    @Override
    public HistoryJobQuery jobTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("Provided tenant id is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public HistoryJobQuery jobTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("Provided tenant id is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    @Override
    public HistoryJobQuery jobWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    @Override
    public HistoryJobQuery lockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
        return this;
    }

    @Override
    public HistoryJobQuery locked() {
        this.onlyLocked = true;
        return this;
    }

    @Override
    public HistoryJobQuery unlocked() {
        this.onlyUnlocked = true;
        return this;
    }

    @Override
    public HistoryJobQuery orderByJobDuedate() {
        return (HistoryJobQuery)this.orderBy(JobQueryProperty.DUEDATE);
    }

    @Override
    public HistoryJobQuery orderByExecutionId() {
        return (HistoryJobQuery)this.orderBy(JobQueryProperty.EXECUTION_ID);
    }

    @Override
    public HistoryJobQuery orderByJobId() {
        return (HistoryJobQuery)this.orderBy(JobQueryProperty.JOB_ID);
    }

    @Override
    public HistoryJobQuery orderByProcessInstanceId() {
        return (HistoryJobQuery)this.orderBy(JobQueryProperty.PROCESS_INSTANCE_ID);
    }

    @Override
    public HistoryJobQuery orderByJobRetries() {
        return (HistoryJobQuery)this.orderBy(JobQueryProperty.RETRIES);
    }

    @Override
    public HistoryJobQuery orderByTenantId() {
        return (HistoryJobQuery)this.orderBy(JobQueryProperty.TENANT_ID);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return CommandContextUtil.getHistoryJobEntityManager(commandContext).findHistoryJobCountByQueryCriteria(this);
    }

    @Override
    public List<HistoryJob> executeList(CommandContext commandContext) {
        this.checkQueryOk();
        return CommandContextUtil.getHistoryJobEntityManager(commandContext).findHistoryJobsByQueryCriteria(this);
    }

    public String getHandlerType() {
        return this.handlerType;
    }

    public boolean getRetriesLeft() {
        return this.retriesLeft;
    }

    public Date getNow() {
        return CommandContextUtil.getProcessEngineConfiguration().getClock().getCurrentTime();
    }

    public boolean isWithException() {
        return this.withException;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    public String getId() {
        return this.id;
    }

    public boolean isNoRetriesLeft() {
        return this.noRetriesLeft;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public boolean isOnlyLocked() {
        return this.onlyLocked;
    }

    public boolean isOnlyUnlocked() {
        return this.onlyUnlocked;
    }
}

