/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.event;

import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.EventSubProcessStartEventActivityBehavior;
import org.activiti.engine.impl.event.EventHandler;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public abstract class AbstractEventHandler
implements EventHandler {
    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        ActivityBehavior activityBehavior;
        ExecutionEntity execution = eventSubscription.getExecution();
        ActivityImpl activity = eventSubscription.getActivity();
        if (activity == null) {
            throw new ActivitiException("Error while sending signal for event subscription '" + eventSubscription.getId() + "': no activity associated with event subscription");
        }
        if (payload instanceof Map) {
            Map processVariables = (Map)payload;
            execution.setVariables(processVariables);
        }
        if ((activityBehavior = activity.getActivityBehavior()) instanceof BoundaryEventActivityBehavior || activityBehavior instanceof EventSubProcessStartEventActivityBehavior) {
            try {
                this.dispatchActivitiesCanceledIfNeeded(eventSubscription, execution, activity, commandContext);
                activityBehavior.execute(execution);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ActivitiException("exception while sending signal for event subscription '" + eventSubscription + "':" + e.getMessage(), e);
            }
        } else {
            if (!activity.equals(execution.getActivity())) {
                execution.setActivity(activity);
            }
            execution.signal(eventSubscription.getEventName(), payload);
        }
    }

    protected void dispatchActivitiesCanceledIfNeeded(EventSubscriptionEntity eventSubscription, ExecutionEntity execution, ActivityImpl boundaryEventActivity, CommandContext commandContext) {
        BoundaryEventActivityBehavior boundaryEventActivityBehavior;
        ActivityBehavior boundaryActivityBehavior = boundaryEventActivity.getActivityBehavior();
        if (boundaryActivityBehavior instanceof BoundaryEventActivityBehavior && (boundaryEventActivityBehavior = (BoundaryEventActivityBehavior)boundaryActivityBehavior).isInterrupting()) {
            this.dispatchExecutionCancelled(eventSubscription, execution, commandContext);
        }
    }

    protected void dispatchExecutionCancelled(EventSubscriptionEntity eventSubscription, ExecutionEntity execution, CommandContext commandContext) {
        ActivityImpl activity;
        for (ExecutionEntity subExecution : execution.getExecutions()) {
            this.dispatchExecutionCancelled(eventSubscription, subExecution, commandContext);
        }
        ExecutionEntity subProcessInstance = commandContext.getExecutionEntityManager().findSubProcessInstanceBySuperExecutionId(execution.getId());
        if (subProcessInstance != null) {
            this.dispatchExecutionCancelled(eventSubscription, subProcessInstance, commandContext);
        }
        if ((activity = execution.getActivity()) != null && activity.getActivityBehavior() != null) {
            this.dispatchActivityCancelled(eventSubscription, execution, activity, commandContext);
        }
    }

    protected void dispatchActivityCancelled(EventSubscriptionEntity eventSubscription, ExecutionEntity execution, ActivityImpl activity, CommandContext commandContext) {
        commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityCancelledEvent(activity.getId(), (String)activity.getProperties().get("name"), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), (String)activity.getProperties().get("type"), activity.getActivityBehavior().getClass().getCanonicalName(), eventSubscription));
    }
}

