/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.dynamic;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ScriptTask;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.DynamicBpmnConstants;
import org.activiti.engine.dynamic.DefaultPropertiesParser;
import org.activiti.engine.dynamic.PropertiesParser;
import org.activiti.engine.dynamic.ScriptTaskPropertiesParser;
import org.activiti.engine.dynamic.UserTaskPropertiesParser;

public class DynamicProcessDefinitionSummary
implements DynamicBpmnConstants {
    private static final HashMap<String, PropertiesParser> summaryParsers = new HashMap();
    private static final PropertiesParser defaultParser = new DefaultPropertiesParser();
    private BpmnModel bpmnModel;
    private ObjectNode processInfo;
    private ObjectMapper objectMapper;

    public DynamicProcessDefinitionSummary(BpmnModel bpmnModel, ObjectNode processInfo, ObjectMapper objectMapper) {
        this.bpmnModel = bpmnModel;
        this.processInfo = processInfo;
        this.objectMapper = objectMapper;
    }

    public ObjectNode getElement(String elementId) throws IllegalStateException {
        FlowElement flowElement = this.bpmnModel.getFlowElement(elementId);
        if (flowElement == null) {
            throw new IllegalStateException("No flow element with id " + elementId + " found in bpmnmodel " + this.bpmnModel.getMainProcess().getId());
        }
        PropertiesParser propertiesParser = summaryParsers.get(flowElement.getClass().getSimpleName());
        ObjectNode bpmnProperties = this.getBpmnProperties(elementId, this.processInfo);
        if (propertiesParser != null) {
            return propertiesParser.parseElement(flowElement, bpmnProperties, this.objectMapper);
        }
        return defaultParser.parseElement(flowElement, bpmnProperties, this.objectMapper);
    }

    public ObjectNode getSummary() {
        ObjectNode summary = this.objectMapper.createObjectNode();
        for (Process process : this.bpmnModel.getProcesses()) {
            for (FlowElement flowElement : process.getFlowElements()) {
                summary.set(flowElement.getId(), (JsonNode)this.getElement(flowElement.getId()));
            }
        }
        return summary;
    }

    protected ObjectNode getBpmnProperties(String elementId, ObjectNode processInfoNode) {
        JsonNode bpmnNode = processInfoNode.get("bpmn");
        if (bpmnNode != null) {
            JsonNode elementNode = bpmnNode.get(elementId);
            if (elementNode == null) {
                return this.objectMapper.createObjectNode();
            }
            return (ObjectNode)elementNode;
        }
        return this.objectMapper.createObjectNode();
    }

    static {
        summaryParsers.put(UserTask.class.getSimpleName(), new UserTaskPropertiesParser());
        summaryParsers.put(ScriptTask.class.getSimpleName(), new ScriptTaskPropertiesParser());
    }
}

