/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.el;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.delegate.FlowableFunctionDelegate;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionFactoryResolver;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.el.FlowableAstFunctionCreator;
import org.flowable.common.engine.impl.el.FlowableElContext;
import org.flowable.common.engine.impl.el.FlowableExpressionFactory;
import org.flowable.common.engine.impl.el.FlowableFunctionMapper;
import org.flowable.common.engine.impl.el.FlowableFunctionResolver;
import org.flowable.common.engine.impl.el.FlowableFunctionResolverFactory;
import org.flowable.common.engine.impl.el.FunctionDelegatesFlowableFunctionResolver;
import org.flowable.common.engine.impl.el.JsonNodeELResolver;
import org.flowable.common.engine.impl.el.JuelExpression;
import org.flowable.common.engine.impl.el.ParsingElContext;
import org.flowable.common.engine.impl.el.ReadOnlyMapELResolver;
import org.flowable.common.engine.impl.el.VariableContainerELResolver;
import org.flowable.common.engine.impl.javax.el.ArrayELResolver;
import org.flowable.common.engine.impl.javax.el.BeanELResolver;
import org.flowable.common.engine.impl.javax.el.CompositeELResolver;
import org.flowable.common.engine.impl.javax.el.CouldNotResolvePropertyELResolver;
import org.flowable.common.engine.impl.javax.el.ELContext;
import org.flowable.common.engine.impl.javax.el.ELResolver;
import org.flowable.common.engine.impl.javax.el.ExpressionFactory;
import org.flowable.common.engine.impl.javax.el.ListELResolver;
import org.flowable.common.engine.impl.javax.el.MapELResolver;
import org.flowable.common.engine.impl.javax.el.ValueExpression;
import org.flowable.common.engine.impl.persistence.deploy.DeploymentCache;

public class DefaultExpressionManager
implements ExpressionManager {
    protected ExpressionFactory expressionFactory;
    protected List<FlowableFunctionDelegate> functionDelegates;
    protected FlowableFunctionResolver functionResolver;
    protected FlowableFunctionResolverFactory functionResolverFactory = FunctionDelegatesFlowableFunctionResolver::new;
    protected List<FlowableAstFunctionCreator> astFunctionCreators;
    protected ELContext parsingElContext;
    protected Map<Object, Object> beans;
    protected DeploymentCache<Expression> expressionCache;
    protected int expressionTextLengthCacheLimit = -1;
    protected List<ELResolver> preDefaultResolvers;
    protected ELResolver jsonNodeResolver;
    protected List<ELResolver> postDefaultResolvers;
    protected List<ELResolver> preBeanResolvers;
    protected ELResolver beanResolver;
    protected ELResolver staticElResolver;

    public DefaultExpressionManager(Map<Object, Object> beans) {
        this.expressionFactory = ExpressionFactoryResolver.resolveExpressionFactory();
        this.beans = beans;
    }

    @Override
    public Expression createExpression(String text) {
        Expression cachedExpression;
        if (this.isCacheEnabled(text) && (cachedExpression = this.expressionCache.get(text)) != null) {
            return cachedExpression;
        }
        if (this.parsingElContext == null) {
            this.parsingElContext = new ParsingElContext(this.functionResolver);
        } else if (this.parsingElContext.getFunctionMapper() != null && this.parsingElContext.getFunctionMapper() instanceof FlowableFunctionMapper) {
            ((FlowableFunctionMapper)this.parsingElContext.getFunctionMapper()).setFunctionResolver(this.functionResolver);
        }
        String expressionText = text.trim();
        ValueExpression valueExpression = this.expressionFactory.createValueExpression(this.parsingElContext, expressionText, Object.class);
        Expression expression = this.createJuelExpression(text, valueExpression);
        if (this.isCacheEnabled(text)) {
            this.expressionCache.add(text, expression);
        }
        return expression;
    }

    protected boolean isCacheEnabled(String text) {
        return this.expressionCache != null && (this.expressionTextLengthCacheLimit < 0 || text.length() <= this.expressionTextLengthCacheLimit);
    }

    protected Expression createJuelExpression(String expression, ValueExpression valueExpression) {
        return new JuelExpression(this, valueExpression, expression);
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    @Override
    public ELContext getElContext(VariableContainer variableContainer) {
        ELResolver elResolver = this.getOrCreateStaticElResolver();
        return new FlowableElContext(elResolver, this.functionResolver);
    }

    protected ELResolver getOrCreateStaticElResolver() {
        if (this.staticElResolver == null) {
            this.staticElResolver = new CompositeELResolver(this.createDefaultElResolvers());
        }
        return this.staticElResolver;
    }

    protected List<ELResolver> createDefaultElResolvers() {
        ELResolver beanElResolver;
        ArrayList<ELResolver> elResolvers = new ArrayList<ELResolver>();
        elResolvers.add(this.createVariableElResolver());
        if (this.preDefaultResolvers != null) {
            elResolvers.addAll(this.preDefaultResolvers);
        }
        if (this.beans != null) {
            elResolvers.add(new ReadOnlyMapELResolver(this.beans));
        }
        elResolvers.add(new ArrayELResolver());
        elResolvers.add(new ListELResolver());
        elResolvers.add(new MapELResolver());
        ELResolver jsonNodeElResolver = this.createJsonNodeElResolver();
        if (jsonNodeElResolver != null) {
            elResolvers.add(jsonNodeElResolver);
        }
        if (this.preBeanResolvers != null) {
            elResolvers.addAll(this.preBeanResolvers);
        }
        if ((beanElResolver = this.createBeanElResolver()) != null) {
            elResolvers.add(beanElResolver);
        }
        if (this.postDefaultResolvers != null) {
            elResolvers.addAll(this.postDefaultResolvers);
        }
        elResolvers.add(new CouldNotResolvePropertyELResolver());
        return elResolvers;
    }

    protected ELResolver createVariableElResolver() {
        return new VariableContainerELResolver();
    }

    protected ELResolver createJsonNodeElResolver() {
        return this.jsonNodeResolver == null ? new JsonNodeELResolver() : this.jsonNodeResolver;
    }

    protected ELResolver createBeanElResolver() {
        return this.beanResolver == null ? new BeanELResolver() : this.beanResolver;
    }

    @Override
    public Map<Object, Object> getBeans() {
        return this.beans;
    }

    @Override
    public void setBeans(Map<Object, Object> beans) {
        this.staticElResolver = null;
        this.beans = beans;
    }

    @Override
    public List<FlowableFunctionDelegate> getFunctionDelegates() {
        return this.functionDelegates;
    }

    @Override
    public void setFunctionDelegates(List<FlowableFunctionDelegate> functionDelegates) {
        this.functionDelegates = functionDelegates;
        this.updateFunctionResolver();
    }

    protected void updateFunctionResolver() {
        this.functionResolver = this.functionDelegates != null ? this.functionResolverFactory.create(this.functionDelegates) : null;
    }

    @Override
    public List<FlowableAstFunctionCreator> getAstFunctionCreators() {
        return this.astFunctionCreators;
    }

    @Override
    public void setAstFunctionCreators(List<FlowableAstFunctionCreator> astFunctionCreators) {
        this.astFunctionCreators = astFunctionCreators;
        if (this.expressionFactory instanceof FlowableExpressionFactory) {
            ((FlowableExpressionFactory)this.expressionFactory).setAstFunctionCreators(astFunctionCreators);
        }
    }

    @Override
    public FlowableFunctionResolverFactory getFunctionResolverFactory() {
        return this.functionResolverFactory;
    }

    @Override
    public void setFunctionResolverFactory(FlowableFunctionResolverFactory functionResolverFactory) {
        this.functionResolverFactory = functionResolverFactory;
        this.updateFunctionResolver();
    }

    public DeploymentCache<Expression> getExpressionCache() {
        return this.expressionCache;
    }

    public void setExpressionCache(DeploymentCache<Expression> expressionCache) {
        this.expressionCache = expressionCache;
    }

    public int getExpressionTextLengthCacheLimit() {
        return this.expressionTextLengthCacheLimit;
    }

    public void setExpressionTextLengthCacheLimit(int expressionTextLengthCacheLimit) {
        this.expressionTextLengthCacheLimit = expressionTextLengthCacheLimit;
    }

    public void addPreDefaultResolver(ELResolver elResolver) {
        if (this.preDefaultResolvers == null) {
            this.preDefaultResolvers = new ArrayList<ELResolver>();
        }
        this.preDefaultResolvers.add(elResolver);
    }

    public ELResolver getJsonNodeResolver() {
        return this.jsonNodeResolver;
    }

    public void setJsonNodeResolver(ELResolver jsonNodeResolver) {
        this.staticElResolver = null;
        this.jsonNodeResolver = jsonNodeResolver;
    }

    public void addPostDefaultResolver(ELResolver elResolver) {
        if (this.postDefaultResolvers == null) {
            this.postDefaultResolvers = new ArrayList<ELResolver>();
        }
        this.postDefaultResolvers.add(elResolver);
    }

    public void addPreBeanResolver(ELResolver elResolver) {
        if (this.preBeanResolvers == null) {
            this.preBeanResolvers = new ArrayList<ELResolver>();
        }
        this.preBeanResolvers.add(elResolver);
    }

    public ELResolver getBeanResolver() {
        return this.beanResolver;
    }

    public void setBeanResolver(ELResolver beanResolver) {
        this.staticElResolver = null;
        this.beanResolver = beanResolver;
    }
}

