/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.cmd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.entity.PropertyEntity;
import org.flowable.common.engine.impl.persistence.entity.PropertyEntityManager;

public class LockCmd
implements Command<Boolean> {
    protected static final String hostLockDescription;
    protected String lockName;
    protected String engineType;

    public LockCmd(String lockName, String engineType) {
        this.lockName = lockName;
        this.engineType = engineType;
    }

    @Override
    public Boolean execute(CommandContext commandContext) {
        AbstractEngineConfiguration engineConfiguration = commandContext.getEngineConfigurations().get(this.engineType);
        PropertyEntityManager propertyEntityManager = engineConfiguration.getPropertyEntityManager();
        PropertyEntity property = (PropertyEntity)propertyEntityManager.findById(this.lockName);
        if (property == null) {
            property = (PropertyEntity)propertyEntityManager.create();
            property.setName(this.lockName);
            property.setValue(Instant.now().toString() + hostLockDescription);
            propertyEntityManager.insert(property);
            return true;
        }
        return false;
    }

    static {
        InetAddress localhost;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            localhost = null;
        }
        StringBuilder sb = new StringBuilder();
        if (localhost != null) {
            sb.append(" - ").append(localhost.getHostName()).append('(').append(localhost.getHostAddress()).append(')');
        } else {
            sb.append(" - ").append("unknown");
        }
        hostLockDescription = sb.substring(0, Math.min(sb.length(), 228));
    }
}

