/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.impl.el;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.flowable.engine.common.api.delegate.Expression;
import org.flowable.engine.common.api.delegate.FlowableFunctionDelegate;
import org.flowable.engine.common.api.variable.VariableContainer;
import org.flowable.engine.common.impl.el.ExpressionFactoryResolver;
import org.flowable.engine.common.impl.el.ExpressionManager;
import org.flowable.engine.common.impl.el.FlowableElContext;
import org.flowable.engine.common.impl.el.FlowableFunctionMapper;
import org.flowable.engine.common.impl.el.JsonNodeELResolver;
import org.flowable.engine.common.impl.el.JuelExpression;
import org.flowable.engine.common.impl.el.ParsingElContext;
import org.flowable.engine.common.impl.el.ReadOnlyMapELResolver;
import org.flowable.engine.common.impl.el.VariableContainerELResolver;
import org.flowable.engine.common.impl.javax.el.ArrayELResolver;
import org.flowable.engine.common.impl.javax.el.BeanELResolver;
import org.flowable.engine.common.impl.javax.el.CompositeELResolver;
import org.flowable.engine.common.impl.javax.el.ELContext;
import org.flowable.engine.common.impl.javax.el.ELResolver;
import org.flowable.engine.common.impl.javax.el.ExpressionFactory;
import org.flowable.engine.common.impl.javax.el.ListELResolver;
import org.flowable.engine.common.impl.javax.el.MapELResolver;
import org.flowable.engine.common.impl.javax.el.ValueExpression;

public class DefaultExpressionManager
implements ExpressionManager {
    protected ExpressionFactory expressionFactory = ExpressionFactoryResolver.resolveExpressionFactory();
    protected List<FlowableFunctionDelegate> functionDelegates;
    protected ELContext parsingElContext;
    protected Map<Object, Object> beans;

    public DefaultExpressionManager() {
        this(null);
    }

    public DefaultExpressionManager(Map<Object, Object> beans) {
        this.beans = beans;
    }

    @Override
    public Expression createExpression(String expression) {
        if (this.parsingElContext == null) {
            this.parsingElContext = new ParsingElContext(this.functionDelegates);
        } else if (this.parsingElContext.getFunctionMapper() != null && this.parsingElContext.getFunctionMapper() instanceof FlowableFunctionMapper) {
            ((FlowableFunctionMapper)this.parsingElContext.getFunctionMapper()).setFunctionDelegates(this.functionDelegates);
        }
        ValueExpression valueExpression = this.expressionFactory.createValueExpression(this.parsingElContext, expression.trim(), Object.class);
        return this.createJuelExpression(expression, valueExpression);
    }

    protected Expression createJuelExpression(String expression, ValueExpression valueExpression) {
        return new JuelExpression(this, valueExpression, expression);
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    @Override
    public ELContext getElContext(VariableContainer variableContainer) {
        ELResolver elResolver = this.createElResolver(variableContainer);
        return new FlowableElContext(elResolver, this.functionDelegates);
    }

    protected ELResolver createElResolver(VariableContainer variableContainer) {
        ArrayList<ELResolver> elResolvers = new ArrayList<ELResolver>();
        elResolvers.add(this.createVariableElResolver(variableContainer));
        if (this.beans != null) {
            elResolvers.add(new ReadOnlyMapELResolver(this.beans));
        }
        elResolvers.add(new ArrayELResolver());
        elResolvers.add(new ListELResolver());
        elResolvers.add(new MapELResolver());
        elResolvers.add(new JsonNodeELResolver());
        ELResolver beanElResolver = this.createBeanElResolver();
        if (beanElResolver != null) {
            elResolvers.add(beanElResolver);
        }
        this.configureResolvers(elResolvers);
        CompositeELResolver compositeELResolver = new CompositeELResolver();
        for (ELResolver elResolver : elResolvers) {
            compositeELResolver.add(elResolver);
        }
        return compositeELResolver;
    }

    protected void configureResolvers(List<ELResolver> elResolvers) {
    }

    protected ELResolver createVariableElResolver(VariableContainer variableContainer) {
        return new VariableContainerELResolver(variableContainer);
    }

    protected ELResolver createBeanElResolver() {
        return new BeanELResolver();
    }

    @Override
    public Map<Object, Object> getBeans() {
        return this.beans;
    }

    @Override
    public void setBeans(Map<Object, Object> beans) {
        this.beans = beans;
    }

    @Override
    public List<FlowableFunctionDelegate> getFunctionDelegates() {
        return this.functionDelegates;
    }

    @Override
    public void setFunctionDelegates(List<FlowableFunctionDelegate> functionDelegates) {
        this.functionDelegates = functionDelegates;
    }
}

