/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.impl.calendar;

import java.util.Date;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.calendar.BusinessCalendarImpl;
import org.flowable.engine.common.impl.runtime.ClockReader;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public class DueDateBusinessCalendar
extends BusinessCalendarImpl {
    public static final String NAME = "dueDate";

    public DueDateBusinessCalendar(ClockReader clockReader) {
        super(clockReader);
    }

    @Override
    public Date resolveDuedate(String duedate, int maxIterations) {
        try {
            if (duedate.startsWith("P")) {
                return new DateTime((Object)this.clockReader.getCurrentTime()).plus((ReadablePeriod)Period.parse((String)duedate)).toDate();
            }
            return DateTime.parse((String)duedate).toDate();
        }
        catch (Exception e) {
            throw new FlowableException("couldn't resolve duedate: " + e.getMessage(), (Throwable)e);
        }
    }
}

