/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.hitpolicy;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.flowable.dmn.engine.impl.el.ELExecutionContext;
import org.flowable.dmn.engine.impl.hitpolicy.AbstractHitPolicy;
import org.flowable.dmn.engine.impl.hitpolicy.ComposeDecisionResultBehavior;
import org.flowable.dmn.model.BuiltinAggregator;
import org.flowable.dmn.model.HitPolicy;

public class HitPolicyCollect
extends AbstractHitPolicy
implements ComposeDecisionResultBehavior {
    @Override
    public String getHitPolicyName() {
        return HitPolicy.COLLECT.getValue();
    }

    @Override
    public void composeDecisionResults(ELExecutionContext executionContext) {
        ArrayList<Object> decisionResults = new ArrayList();
        if (executionContext.getRuleResults() != null && !executionContext.getRuleResults().isEmpty()) {
            if (executionContext.getAggregator() == null) {
                decisionResults = new ArrayList<Map<String, Object>>(executionContext.getRuleResults().values());
            } else {
                Map.Entry<String, List<Double>> outputValuesEntry = this.composeOutputValues(executionContext);
                if (executionContext.getAggregator() == BuiltinAggregator.SUM) {
                    if (outputValuesEntry != null) {
                        Double sumResult = this.aggregateSum(outputValuesEntry.getValue());
                        decisionResults.add(this.createDecisionResults(outputValuesEntry.getKey(), sumResult));
                    }
                } else if (executionContext.getAggregator() == BuiltinAggregator.MIN) {
                    if (outputValuesEntry != null) {
                        Double minResult = this.aggregateMin(outputValuesEntry.getValue());
                        decisionResults.add(this.createDecisionResults(outputValuesEntry.getKey(), minResult));
                    }
                } else if (executionContext.getAggregator() == BuiltinAggregator.MAX) {
                    if (outputValuesEntry != null) {
                        Double maxResult = this.aggregateMax(outputValuesEntry.getValue());
                        decisionResults.add(this.createDecisionResults(outputValuesEntry.getKey(), maxResult));
                    }
                } else if (executionContext.getAggregator() == BuiltinAggregator.COUNT && outputValuesEntry != null) {
                    Double countResult = this.aggregateCount(outputValuesEntry.getValue());
                    decisionResults.add(this.createDecisionResults(outputValuesEntry.getKey(), countResult));
                }
            }
        }
        executionContext.getAuditContainer().setDecisionResult(decisionResults);
        executionContext.getAuditContainer().setMultipleResults(this.isMultipleResults(executionContext.getAggregator()));
    }

    protected boolean isMultipleResults(BuiltinAggregator aggregator) {
        return aggregator == null;
    }

    protected Map.Entry<String, List<Double>> composeOutputValues(ELExecutionContext executionContext) {
        AbstractCollection ruleResults = new ArrayList<Map<String, Object>>(executionContext.getRuleResults().values());
        if (executionContext.isForceDMN11()) {
            ruleResults = new HashSet<Map<String, Object>>(ruleResults);
        }
        return this.createOutputDoubleValues(ruleResults);
    }

    protected Map.Entry<String, List<Double>> createOutputDoubleValues(Collection<Map<String, Object>> ruleResults) {
        HashMap distinctOutputDoubleValues = new HashMap();
        for (Map<String, Object> ruleResult : ruleResults) {
            for (Map.Entry<String, Object> entry : ruleResult.entrySet()) {
                if (distinctOutputDoubleValues.containsKey(entry.getKey()) && distinctOutputDoubleValues.get(entry.getKey()) != null) {
                    ((List)distinctOutputDoubleValues.get(entry.getKey())).add((Double)entry.getValue());
                    continue;
                }
                ArrayList<Double> valuesList = new ArrayList<Double>();
                valuesList.add((Double)entry.getValue());
                distinctOutputDoubleValues.put(entry.getKey(), valuesList);
            }
        }
        Map.Entry firstEntry = null;
        if (!distinctOutputDoubleValues.isEmpty()) {
            firstEntry = distinctOutputDoubleValues.entrySet().iterator().next();
        }
        return firstEntry;
    }

    protected Double aggregateSum(List<Double> values) {
        double aggregate = 0.0;
        for (Double value : values) {
            aggregate += value.doubleValue();
        }
        return aggregate;
    }

    protected Double aggregateMin(List<Double> values) {
        return Collections.min(values);
    }

    protected Double aggregateMax(List<Double> values) {
        return Collections.max(values);
    }

    protected Double aggregateCount(List<Double> values) {
        return values.size();
    }

    protected Map<String, Object> createDecisionResults(String outputName, Double outputValue) {
        HashMap<String, Object> ruleResult = new HashMap<String, Object>();
        ruleResult.put(outputName, outputValue);
        return ruleResult;
    }
}

