/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.persistence.entity.AbstractEngineEntityManager;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.dmn.api.DmnDecisionTable;
import org.flowable.dmn.api.DmnDeployment;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.DmnDeploymentQueryImpl;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntityManager;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntityManager;
import org.flowable.dmn.engine.impl.persistence.entity.DmnResourceEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnResourceEntityManager;
import org.flowable.dmn.engine.impl.persistence.entity.HistoricDecisionExecutionEntityManager;
import org.flowable.dmn.engine.impl.persistence.entity.data.DmnDeploymentDataManager;

public class DmnDeploymentEntityManagerImpl
extends AbstractEngineEntityManager<DmnEngineConfiguration, DmnDeploymentEntity, DmnDeploymentDataManager>
implements DmnDeploymentEntityManager {
    public DmnDeploymentEntityManagerImpl(DmnEngineConfiguration dmnEngineConfiguration, DmnDeploymentDataManager deploymentDataManager) {
        super((AbstractEngineConfiguration)dmnEngineConfiguration, (DataManager)deploymentDataManager);
    }

    public void insert(DmnDeploymentEntity deployment) {
        super.insert((Entity)deployment, true);
        for (EngineResource resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getResourceEntityManager().insert((DmnResourceEntity)resource);
        }
    }

    @Override
    public void deleteDeployment(String deploymentId) {
        this.getHistoricDecisionExecutionEntityManager().deleteHistoricDecisionExecutionsByDeploymentId(deploymentId);
        this.getDecisionTableEntityManager().deleteDecisionTablesByDeploymentId(deploymentId);
        this.getResourceEntityManager().deleteResourcesByDeploymentId(deploymentId);
        this.delete(this.findById(deploymentId));
    }

    protected DecisionTableEntity findLatestDecisionTable(DmnDecisionTable decisionTable) {
        DecisionTableEntity latestDecisionTable = null;
        latestDecisionTable = decisionTable.getTenantId() != null && !"".equals(decisionTable.getTenantId()) ? this.getDecisionTableEntityManager().findLatestDecisionTableByKeyAndTenantId(decisionTable.getKey(), decisionTable.getTenantId()) : this.getDecisionTableEntityManager().findLatestDecisionTableByKey(decisionTable.getKey());
        return latestDecisionTable;
    }

    @Override
    public long findDeploymentCountByQueryCriteria(DmnDeploymentQueryImpl deploymentQuery) {
        return ((DmnDeploymentDataManager)this.dataManager).findDeploymentCountByQueryCriteria(deploymentQuery);
    }

    @Override
    public List<DmnDeployment> findDeploymentsByQueryCriteria(DmnDeploymentQueryImpl deploymentQuery) {
        return ((DmnDeploymentDataManager)this.dataManager).findDeploymentsByQueryCriteria(deploymentQuery);
    }

    @Override
    public List<String> getDeploymentResourceNames(String deploymentId) {
        return ((DmnDeploymentDataManager)this.dataManager).getDeploymentResourceNames(deploymentId);
    }

    @Override
    public List<DmnDeployment> findDeploymentsByNativeQuery(Map<String, Object> parameterMap) {
        return ((DmnDeploymentDataManager)this.dataManager).findDeploymentsByNativeQuery(parameterMap);
    }

    @Override
    public long findDeploymentCountByNativeQuery(Map<String, Object> parameterMap) {
        return ((DmnDeploymentDataManager)this.dataManager).findDeploymentCountByNativeQuery(parameterMap);
    }

    protected DmnResourceEntityManager getResourceEntityManager() {
        return ((DmnEngineConfiguration)this.engineConfiguration).getResourceEntityManager();
    }

    protected HistoricDecisionExecutionEntityManager getHistoricDecisionExecutionEntityManager() {
        return ((DmnEngineConfiguration)this.engineConfiguration).getHistoricDecisionExecutionEntityManager();
    }

    protected DecisionTableEntityManager getDecisionTableEntityManager() {
        return ((DmnEngineConfiguration)this.engineConfiguration).getDecisionTableEntityManager();
    }
}

