/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.dmn.api.DecisionExecutionAuditContainer;
import org.flowable.dmn.api.ExecuteDecisionBuilder;
import org.flowable.dmn.engine.impl.DmnRuleServiceImpl;

public class ExecuteDecisionBuilderImpl
implements ExecuteDecisionBuilder {
    protected DmnRuleServiceImpl ruleService;
    protected String decisionKey;
    protected String parentDeploymentId;
    protected String instanceId;
    protected String executionId;
    protected String activityId;
    protected String scopeType;
    protected String tenantId;
    protected Map<String, Object> variables;
    protected boolean fallbackToDefaultTenant;

    public ExecuteDecisionBuilderImpl(DmnRuleServiceImpl ruleService) {
        this.ruleService = ruleService;
    }

    public ExecuteDecisionBuilder decisionKey(String decisionKey) {
        this.decisionKey = decisionKey;
        return this;
    }

    public ExecuteDecisionBuilder parentDeploymentId(String parentDeploymentId) {
        this.parentDeploymentId = parentDeploymentId;
        return this;
    }

    public ExecuteDecisionBuilder instanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public ExecuteDecisionBuilder executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    public ExecuteDecisionBuilder activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    public ExecuteDecisionBuilder scopeType(String scopeType) {
        this.scopeType = scopeType;
        return this;
    }

    public ExecuteDecisionBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public ExecuteDecisionBuilder fallbackToDefaultTenant() {
        this.fallbackToDefaultTenant = true;
        return this;
    }

    public ExecuteDecisionBuilder variables(Map<String, Object> variables) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                this.variables.put(variableName, variables.get(variableName));
            }
        }
        return this;
    }

    public ExecuteDecisionBuilder variable(String variableName, Object value) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(variableName, value);
        return this;
    }

    public List<Map<String, Object>> execute() {
        return this.ruleService.executeDecision(this);
    }

    public Map<String, Object> executeWithSingleResult() {
        return this.ruleService.executeDecisionWithSingleResult(this);
    }

    public DecisionExecutionAuditContainer executeWithAuditTrail() {
        return this.ruleService.executeDecisionWithAuditTrail(this);
    }

    public String getDecisionKey() {
        return this.decisionKey;
    }

    public String getParentDeploymentId() {
        return this.parentDeploymentId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean isFallbackToDefaultTenant() {
        return this.fallbackToDefaultTenant;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }
}

