/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.util;

import org.flowable.common.engine.api.FlowableException;
import org.flowable.dmn.engine.impl.persistence.deploy.DecisionTableCacheEntry;
import org.flowable.dmn.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntityManager;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DmnDefinition;

public class DecisionTableUtil {
    public static DecisionTableEntity getDecisionTableEntity(String decisionTableId) {
        return DecisionTableUtil.getDecisionTableEntity(decisionTableId, false);
    }

    public static DecisionTableEntity getDecisionTableEntity(String decisionTableId, boolean checkCacheOnly) {
        if (checkCacheOnly) {
            DecisionTableCacheEntry cacheEntry = (DecisionTableCacheEntry)CommandContextUtil.getDmnEngineConfiguration().getDecisionCache().get(decisionTableId);
            if (cacheEntry != null) {
                return cacheEntry.getDecisionTableEntity();
            }
            return null;
        }
        return CommandContextUtil.getDmnEngineConfiguration().getDeploymentManager().findDeployedDecisionById(decisionTableId);
    }

    public static Decision getDecision(String decisionTableId) {
        DeploymentManager deploymentManager = CommandContextUtil.getDmnEngineConfiguration().getDeploymentManager();
        DecisionTableEntity decisionTableEntity = deploymentManager.findDeployedDecisionById(decisionTableId);
        return deploymentManager.resolveDecisionTable(decisionTableEntity).getDecision();
    }

    public static DmnDefinition getDmnDefinition(String decisionTableId) {
        DeploymentManager deploymentManager = CommandContextUtil.getDmnEngineConfiguration().getDeploymentManager();
        DecisionTableEntity decisionTableEntity = deploymentManager.findDeployedDecisionById(decisionTableId);
        return deploymentManager.resolveDecisionTable(decisionTableEntity).getDmnDefinition();
    }

    public static DmnDefinition getDmnDefinitionFromCache(String decisionTableId) {
        DecisionTableCacheEntry cacheEntry = (DecisionTableCacheEntry)CommandContextUtil.getDmnEngineConfiguration().getDecisionCache().get(decisionTableId);
        if (cacheEntry != null) {
            return cacheEntry.getDmnDefinition();
        }
        return null;
    }

    public static DecisionTableEntity getDecisionTableFromDatabase(String decisionTableId) {
        DecisionTableEntityManager decisionTableEntityManager = CommandContextUtil.getDmnEngineConfiguration().getDecisionTableEntityManager();
        DecisionTableEntity decisionTable = (DecisionTableEntity)decisionTableEntityManager.findById(decisionTableId);
        if (decisionTable == null) {
            throw new FlowableException("No decision table found with id " + decisionTableId);
        }
        return decisionTable;
    }
}

