/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.hitpolicy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.dmn.engine.impl.el.ELExecutionContext;
import org.flowable.dmn.engine.impl.hitpolicy.AbstractHitPolicy;
import org.flowable.dmn.engine.impl.hitpolicy.ComposeDecisionResultBehavior;
import org.flowable.dmn.engine.impl.hitpolicy.OutputOrderComparator;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.dmn.model.HitPolicy;

public class HitPolicyOutputOrder
extends AbstractHitPolicy
implements ComposeDecisionResultBehavior {
    @Override
    public String getHitPolicyName() {
        return HitPolicy.OUTPUT_ORDER.getValue();
    }

    @Override
    public void composeDecisionResults(final ELExecutionContext executionContext) {
        ArrayList<Map<String, Object>> ruleResults = new ArrayList<Map<String, Object>>(executionContext.getRuleResults().values());
        boolean outputValuesPresent = false;
        for (Map.Entry<String, List<Object>> entry : executionContext.getOutputValues().entrySet()) {
            List<Object> outputValues = entry.getValue();
            if (outputValues == null || outputValues.isEmpty()) continue;
            outputValuesPresent = true;
            break;
        }
        if (!outputValuesPresent) {
            String hitPolicyViolatedMessage = String.format("HitPolicy: %s violated; no output values present", this.getHitPolicyName());
            if (CommandContextUtil.getDmnEngineConfiguration().isStrictMode()) {
                throw new FlowableException(hitPolicyViolatedMessage);
            }
            executionContext.getAuditContainer().setValidationMessage(hitPolicyViolatedMessage);
        }
        Collections.sort(ruleResults, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                CompareToBuilder compareToBuilder = new CompareToBuilder();
                for (Map.Entry<String, List<Object>> entry : executionContext.getOutputValues().entrySet()) {
                    List<Object> outputValues = entry.getValue();
                    if (outputValues == null || outputValues.isEmpty()) continue;
                    compareToBuilder.append(o1.get(entry.getKey()), o2.get(entry.getKey()), (Comparator)new OutputOrderComparator(outputValues.toArray(new Comparable[outputValues.size()])));
                    compareToBuilder.toComparison();
                }
                return compareToBuilder.toComparison();
            }
        });
        executionContext.getAuditContainer().setDecisionResult(ruleResults);
    }
}

