/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.cmd;

import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.api.DecisionExecutionAuditContainer;
import org.flowable.dmn.api.DmnDecisionTable;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.ExecuteDecisionBuilderImpl;
import org.flowable.dmn.engine.impl.cmd.AbstractExecuteDecisionCmd;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.dmn.model.Decision;

public class ExecuteDecisionSingleResultCmd
extends AbstractExecuteDecisionCmd
implements Command<Map<String, Object>> {
    private static final long serialVersionUID = 1L;

    public ExecuteDecisionSingleResultCmd(ExecuteDecisionBuilderImpl decisionBuilder) {
        super(decisionBuilder);
    }

    public ExecuteDecisionSingleResultCmd(String decisionKey, Map<String, Object> variables) {
        super(decisionKey, variables);
    }

    public ExecuteDecisionSingleResultCmd(String decisionKey, String parentDeploymentId, Map<String, Object> variables) {
        this(decisionKey, variables);
        this.executeDecisionInfo.setParentDeploymentId(parentDeploymentId);
    }

    public ExecuteDecisionSingleResultCmd(String decisionKey, String parentDeploymentId, Map<String, Object> variables, String tenantId) {
        this(decisionKey, parentDeploymentId, variables);
        this.executeDecisionInfo.setTenantId(tenantId);
    }

    public Map<String, Object> execute(CommandContext commandContext) {
        if (this.executeDecisionInfo.getDecisionKey() == null) {
            throw new FlowableIllegalArgumentException("decisionKey is null");
        }
        DmnEngineConfiguration dmnEngineConfiguration = CommandContextUtil.getDmnEngineConfiguration();
        DmnDecisionTable decisionTable = this.resolveDecisionTable();
        Decision decision = this.resolveDecision(decisionTable);
        DecisionExecutionAuditContainer executionResult = dmnEngineConfiguration.getRuleEngineExecutor().execute(decision, this.executeDecisionInfo);
        Map decisionResult = null;
        if (executionResult != null && executionResult.getDecisionResult() != null && !executionResult.getDecisionResult().isEmpty()) {
            if (executionResult.getDecisionResult().size() > 1) {
                throw new FlowableException("more than one result");
            }
            decisionResult = (Map)executionResult.getDecisionResult().get(0);
        }
        return decisionResult;
    }
}

