/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.test;

import java.util.ArrayList;
import java.util.List;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.test.DmnTestHelper;
import org.flowable.engine.common.api.FlowableException;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class FlowableDmnRule
implements TestRule {
    protected String configurationResource = "flowable.dmn.cfg.xml";
    protected String deploymentId;
    protected DmnEngineConfiguration dmnEngineConfiguration;
    protected DmnEngine dmnEngine;
    protected DmnRepositoryService repositoryService;

    public FlowableDmnRule() {
    }

    public FlowableDmnRule(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public FlowableDmnRule(DmnEngine dmnEngine) {
        this.setDmnEngine(dmnEngine);
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                FlowableDmnRule.this.startingQuietly(description, errors);
                try {
                    base.evaluate();
                    FlowableDmnRule.this.succeededQuietly(description, errors);
                }
                catch (AssumptionViolatedException e) {
                    errors.add(e);
                    FlowableDmnRule.this.skippedQuietly(e, description, errors);
                }
                catch (Throwable t) {
                    errors.add(t);
                    FlowableDmnRule.this.failedQuietly(t, description, errors);
                }
                finally {
                    FlowableDmnRule.this.finishedQuietly(description, errors);
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    private void succeededQuietly(Description description, List<Throwable> errors) {
        try {
            this.succeeded(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void failedQuietly(Throwable t, Description description, List<Throwable> errors) {
        try {
            this.failed(t, description);
        }
        catch (Throwable t1) {
            errors.add(t1);
        }
    }

    private void skippedQuietly(AssumptionViolatedException e, Description description, List<Throwable> errors) {
        try {
            this.skipped(e, description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void startingQuietly(Description description, List<Throwable> errors) {
        try {
            this.starting(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void finishedQuietly(Description description, List<Throwable> errors) {
        try {
            this.finished(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    protected void succeeded(Description description) {
    }

    protected void failed(Throwable e, Description description) {
    }

    protected void skipped(AssumptionViolatedException e, Description description) {
    }

    protected void starting(Description description) {
        if (this.dmnEngine == null) {
            this.initializeDmnEngine();
        }
        if (this.dmnEngineConfiguration == null) {
            this.initializeServices();
        }
        this.configureDmnEngine();
        try {
            this.deploymentId = DmnTestHelper.annotationDeploymentSetUp(this.dmnEngine, Class.forName(description.getClassName()), description.getMethodName());
        }
        catch (ClassNotFoundException e) {
            throw new FlowableException("Programmatic error: could not instantiate " + description.getClassName(), (Throwable)e);
        }
    }

    protected void initializeDmnEngine() {
        this.dmnEngine = DmnTestHelper.getDmnEngine(this.configurationResource);
    }

    protected void initializeServices() {
        this.dmnEngineConfiguration = this.dmnEngine.getDmnEngineConfiguration();
        this.repositoryService = this.dmnEngine.getDmnRepositoryService();
    }

    protected void configureDmnEngine() {
    }

    protected void finished(Description description) {
        try {
            DmnTestHelper.annotationDeploymentTearDown(this.dmnEngine, this.deploymentId, Class.forName(description.getClassName()), description.getMethodName());
        }
        catch (ClassNotFoundException e) {
            throw new FlowableException("Programmatic error: could not instantiate " + description.getClassName(), (Throwable)e);
        }
    }

    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public void setConfigurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public DmnEngine getDmnEngine() {
        return this.dmnEngine;
    }

    public void setDmnEngine(DmnEngine dmnEngine) {
        this.dmnEngine = dmnEngine;
        this.initializeServices();
    }

    public DmnRepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(DmnRepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setDmnEngineConfiguration(DmnEngineConfiguration dmnEngineConfiguration) {
        this.dmnEngineConfiguration = dmnEngineConfiguration;
    }
}

