/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.el;

import java.util.List;
import java.util.Map;
import org.flowable.dmn.engine.impl.el.Expression;
import org.flowable.dmn.engine.impl.el.ExpressionManager;
import org.flowable.dmn.engine.impl.el.JuelExpression;
import org.flowable.dmn.engine.impl.el.VariableScopeElResolver;
import org.flowable.engine.common.api.delegate.FlowableFunctionDelegate;
import org.flowable.engine.common.impl.el.ExpressionFactoryResolver;
import org.flowable.engine.common.impl.el.FlowableElContext;
import org.flowable.engine.common.impl.el.JsonNodeELResolver;
import org.flowable.engine.common.impl.el.ParsingElContext;
import org.flowable.engine.common.impl.el.ReadOnlyMapELResolver;
import org.flowable.engine.common.impl.javax.el.ArrayELResolver;
import org.flowable.engine.common.impl.javax.el.BeanELResolver;
import org.flowable.engine.common.impl.javax.el.CompositeELResolver;
import org.flowable.engine.common.impl.javax.el.ELContext;
import org.flowable.engine.common.impl.javax.el.ELResolver;
import org.flowable.engine.common.impl.javax.el.ExpressionFactory;
import org.flowable.engine.common.impl.javax.el.ListELResolver;
import org.flowable.engine.common.impl.javax.el.MapELResolver;
import org.flowable.engine.common.impl.javax.el.ValueExpression;

public class DefaultExpressionManager
implements ExpressionManager {
    protected ExpressionFactory expressionFactory = ExpressionFactoryResolver.resolveExpressionFactory();
    protected List<FlowableFunctionDelegate> functionDelegates;
    protected ELContext parsingElContext;
    protected Map<Object, Object> beans;

    public DefaultExpressionManager() {
        this(null);
    }

    public DefaultExpressionManager(Map<Object, Object> beans) {
        this.beans = beans;
    }

    @Override
    public Expression createExpression(String expression) {
        if (this.parsingElContext == null) {
            this.parsingElContext = new ParsingElContext(this.functionDelegates);
        }
        ValueExpression valueExpression = this.expressionFactory.createValueExpression(this.parsingElContext, expression.trim(), Object.class);
        return new JuelExpression(this, valueExpression, expression);
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    @Override
    public ELContext getElContext(Map<String, Object> variables) {
        return this.createElContext(variables);
    }

    protected FlowableElContext createElContext(Map<String, Object> variables) {
        ELResolver elResolver = this.createElResolver(variables);
        return new FlowableElContext(elResolver, this.functionDelegates);
    }

    protected ELResolver createElResolver(Map<String, Object> variables) {
        CompositeELResolver elResolver = new CompositeELResolver();
        elResolver.add((ELResolver)new VariableScopeElResolver(variables));
        if (this.beans != null) {
            elResolver.add((ELResolver)new ReadOnlyMapELResolver(this.beans));
        }
        elResolver.add((ELResolver)new ArrayELResolver());
        elResolver.add((ELResolver)new ListELResolver());
        elResolver.add((ELResolver)new MapELResolver());
        elResolver.add((ELResolver)new JsonNodeELResolver());
        elResolver.add((ELResolver)new BeanELResolver());
        return elResolver;
    }

    @Override
    public Map<Object, Object> getBeans() {
        return this.beans;
    }

    @Override
    public void setBeans(Map<Object, Object> beans) {
        this.beans = beans;
    }

    @Override
    public List<FlowableFunctionDelegate> getFunctionDelegates() {
        return this.functionDelegates;
    }

    @Override
    public void setFunctionDelegates(List<FlowableFunctionDelegate> functionDelegates) {
        this.functionDelegates = functionDelegates;
    }
}

