/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.deployer;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.flowable.dmn.engine.impl.deployer.ParsedDeployment;
import org.flowable.dmn.engine.impl.parser.DmnParse;
import org.flowable.dmn.engine.impl.parser.DmnParseFactory;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnResourceEntity;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsedDeploymentBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParsedDeploymentBuilder.class);
    public static final String[] DMN_RESOURCE_SUFFIXES = new String[]{"dmn"};
    protected DmnDeploymentEntity deployment;
    protected DmnParseFactory dmnParseFactory;
    protected Map<String, Object> deploymentSettings;

    public ParsedDeploymentBuilder(DmnDeploymentEntity deployment, DmnParseFactory dmnParseFactory, Map<String, Object> deploymentSettings) {
        this.deployment = deployment;
        this.dmnParseFactory = dmnParseFactory;
        this.deploymentSettings = deploymentSettings;
    }

    public ParsedDeployment build() {
        ArrayList<DecisionTableEntity> decisionTables = new ArrayList<DecisionTableEntity>();
        LinkedHashMap<DecisionTableEntity, DmnParse> decisionTablesToDmnParseMap = new LinkedHashMap<DecisionTableEntity, DmnParse>();
        LinkedHashMap<DecisionTableEntity, DmnResourceEntity> decisionTablesToResourceMap = new LinkedHashMap<DecisionTableEntity, DmnResourceEntity>();
        for (DmnResourceEntity resource : this.deployment.getResources().values()) {
            if (!this.isDmnResource(resource.getName())) continue;
            LOGGER.debug("Processing DMN resource {}", (Object)resource.getName());
            DmnParse parse = this.createDmnParseFromResource(resource);
            for (DecisionTableEntity decisionTable : parse.getDecisionTables()) {
                decisionTables.add(decisionTable);
                decisionTablesToDmnParseMap.put(decisionTable, parse);
                decisionTablesToResourceMap.put(decisionTable, resource);
            }
        }
        return new ParsedDeployment(this.deployment, decisionTables, decisionTablesToDmnParseMap, decisionTablesToResourceMap);
    }

    protected DmnParse createDmnParseFromResource(DmnResourceEntity resource) {
        String resourceName = resource.getName();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(resource.getBytes());
        DmnParse dmnParse = this.dmnParseFactory.createParse().sourceInputStream(inputStream).setSourceSystemId(resourceName).deployment(this.deployment).name(resourceName);
        if (this.deploymentSettings != null) {
            if (this.deploymentSettings.containsKey("isDmnXsdValidationEnabled")) {
                dmnParse.setValidateSchema((Boolean)this.deploymentSettings.get("isDmnXsdValidationEnabled"));
            }
        } else {
            dmnParse.setValidateSchema(false);
        }
        dmnParse.execute(CommandContextUtil.getDmnEngineConfiguration());
        return dmnParse;
    }

    protected boolean isDmnResource(String resourceName) {
        for (String suffix : DMN_RESOURCE_SUFFIXES) {
            if (!resourceName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }
}

