/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.deployer;

import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.deployer.ParsedDeployment;
import org.flowable.dmn.engine.impl.persistence.deploy.DecisionTableCacheEntry;
import org.flowable.dmn.engine.impl.persistence.deploy.DeploymentCache;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DmnDefinition;

public class CachingAndArtifactsManager {
    public void updateCachingAndArtifacts(ParsedDeployment parsedDeployment) {
        DmnEngineConfiguration dmnEngineConfiguration = CommandContextUtil.getDmnEngineConfiguration();
        DeploymentCache<DecisionTableCacheEntry> decisionTableCache = dmnEngineConfiguration.getDeploymentManager().getDecisionCache();
        DmnDeploymentEntity deployment = parsedDeployment.getDeployment();
        for (DecisionTableEntity decisionTable : parsedDeployment.getAllDecisionTables()) {
            DmnDefinition dmnDefinition = parsedDeployment.getDmnDefinitionForDecisionTable(decisionTable);
            Decision decision = parsedDeployment.getDecisionForDecisionTable(decisionTable);
            DecisionTableCacheEntry cacheEntry = new DecisionTableCacheEntry(decisionTable, dmnDefinition, decision);
            decisionTableCache.add(decisionTable.getId(), cacheEntry);
            deployment.addDeployedArtifact(decisionTable);
        }
    }
}

