/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.dmn.api.DecisionExecutionAuditContainer;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.RuleEngineExecutor;
import org.flowable.dmn.engine.impl.ExecuteDecisionInfo;
import org.flowable.dmn.engine.impl.el.ELExecutionContext;
import org.flowable.dmn.engine.impl.el.ELExecutionContextBuilder;
import org.flowable.dmn.engine.impl.el.ELExpressionExecutor;
import org.flowable.dmn.engine.impl.el.ExecutionVariableFactory;
import org.flowable.dmn.engine.impl.el.ExpressionManager;
import org.flowable.dmn.engine.impl.hitpolicy.AbstractHitPolicy;
import org.flowable.dmn.engine.impl.hitpolicy.ComposeDecisionResultBehavior;
import org.flowable.dmn.engine.impl.hitpolicy.ComposeRuleResultBehavior;
import org.flowable.dmn.engine.impl.hitpolicy.ContinueEvaluatingBehavior;
import org.flowable.dmn.engine.impl.hitpolicy.EvaluateRuleValidityBehavior;
import org.flowable.dmn.engine.impl.persistence.entity.HistoricDecisionExecutionEntity;
import org.flowable.dmn.engine.impl.persistence.entity.HistoricDecisionExecutionEntityManager;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DecisionRule;
import org.flowable.dmn.model.DecisionTable;
import org.flowable.dmn.model.HitPolicy;
import org.flowable.dmn.model.LiteralExpression;
import org.flowable.dmn.model.OutputClause;
import org.flowable.dmn.model.RuleInputClauseContainer;
import org.flowable.dmn.model.RuleOutputClauseContainer;
import org.flowable.engine.common.api.FlowableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEngineExecutorImpl
implements RuleEngineExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleEngineExecutorImpl.class);
    protected Map<String, AbstractHitPolicy> hitPolicyBehaviors;
    protected ExpressionManager expressionManager;
    protected ObjectMapper objectMapper;

    public RuleEngineExecutorImpl(Map<String, AbstractHitPolicy> hitPolicyBehaviors, ExpressionManager expressionManager, ObjectMapper objectMapper) {
        this.hitPolicyBehaviors = hitPolicyBehaviors;
        this.expressionManager = expressionManager;
        this.objectMapper = objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecisionExecutionAuditContainer execute(Decision decision, ExecuteDecisionInfo executeDecisionInfo) {
        if (decision == null) {
            throw new IllegalArgumentException("no decision provided");
        }
        if (decision.getExpression() == null || !(decision.getExpression() instanceof DecisionTable)) {
            throw new IllegalArgumentException("no decision table present in decision");
        }
        DecisionTable currentDecisionTable = (DecisionTable)decision.getExpression();
        ELExecutionContext executionContext = ELExecutionContextBuilder.build(decision, executeDecisionInfo.getVariables());
        try {
            this.sanityCheckDecisionTable(currentDecisionTable);
            this.evaluateDecisionTable(currentDecisionTable, executionContext);
        }
        catch (FlowableException fe) {
            LOGGER.error("decision table execution sanity check failed", (Throwable)fe);
            executionContext.getAuditContainer().setFailed();
            executionContext.getAuditContainer().setExceptionMessage(this.getExceptionMessage((Exception)((Object)fe)));
        }
        finally {
            executionContext.getAuditContainer().stopAudit();
            DmnEngineConfiguration dmnEngineConfiguration = CommandContextUtil.getDmnEngineConfiguration();
            if (dmnEngineConfiguration.isHistoryEnabled()) {
                HistoricDecisionExecutionEntityManager historicDecisionExecutionEntityManager = dmnEngineConfiguration.getHistoricDecisionExecutionEntityManager();
                HistoricDecisionExecutionEntity decisionExecutionEntity = (HistoricDecisionExecutionEntity)historicDecisionExecutionEntityManager.create();
                decisionExecutionEntity.setDecisionDefinitionId(executeDecisionInfo.getDecisionDefinitionId());
                decisionExecutionEntity.setDeploymentId(executeDecisionInfo.getDeploymentId());
                decisionExecutionEntity.setStartTime(executionContext.getAuditContainer().getStartTime());
                decisionExecutionEntity.setEndTime(executionContext.getAuditContainer().getEndTime());
                decisionExecutionEntity.setInstanceId(executeDecisionInfo.getInstanceId());
                decisionExecutionEntity.setExecutionId(executeDecisionInfo.getExecutionId());
                decisionExecutionEntity.setActivityId(executeDecisionInfo.getActivityId());
                decisionExecutionEntity.setTenantId(executeDecisionInfo.getTenantId());
                Boolean failed = executionContext.getAuditContainer().isFailed();
                if (failed != null) {
                    decisionExecutionEntity.setFailed(failed);
                }
                try {
                    decisionExecutionEntity.setExecutionJson(this.objectMapper.writeValueAsString((Object)executionContext.getAuditContainer()));
                }
                catch (Exception e) {
                    throw new FlowableException("Error writing execution json", (Throwable)e);
                }
                historicDecisionExecutionEntityManager.insert(decisionExecutionEntity);
            }
        }
        return executionContext.getAuditContainer();
    }

    protected void evaluateDecisionTable(DecisionTable decisionTable, ELExecutionContext executionContext) {
        LOGGER.debug("Start table evaluation: {}", (Object)decisionTable.getId());
        if (decisionTable == null || decisionTable.getRules().isEmpty()) {
            throw new IllegalArgumentException("no rules present in table");
        }
        if (executionContext == null) {
            throw new FlowableException("no execution context available");
        }
        try {
            HashMap<Integer, List> validRuleOutputEntries = new HashMap<Integer, List>();
            for (DecisionRule decisionRule : decisionTable.getRules()) {
                boolean ruleResult = this.executeRule(decisionRule, executionContext);
                if (ruleResult) {
                    if (this.getHitPolicyBehavior(decisionTable.getHitPolicy()) instanceof EvaluateRuleValidityBehavior) {
                        ((EvaluateRuleValidityBehavior)((Object)this.getHitPolicyBehavior(decisionTable.getHitPolicy()))).evaluateRuleValidity(decisionRule.getRuleNumber(), executionContext);
                    }
                    validRuleOutputEntries.put(decisionRule.getRuleNumber(), decisionRule.getOutputEntries());
                }
                if (!(this.getHitPolicyBehavior(decisionTable.getHitPolicy()) instanceof ContinueEvaluatingBehavior) || this.getHitPolicyBehavior(decisionTable.getHitPolicy()).shouldContinueEvaluating(ruleResult)) continue;
                LOGGER.debug("Stopping execution; hit policy {} specific behaviour", (Object)decisionTable.getHitPolicy());
                break;
            }
            for (Map.Entry entry : validRuleOutputEntries.entrySet()) {
                this.executeOutputEntryAction((Integer)entry.getKey(), (List)entry.getValue(), decisionTable.getHitPolicy(), executionContext);
            }
            if (this.getHitPolicyBehavior(decisionTable.getHitPolicy()) instanceof ComposeDecisionResultBehavior) {
                this.getHitPolicyBehavior(decisionTable.getHitPolicy()).composeDecisionResults(executionContext);
            }
        }
        catch (FlowableException ade) {
            LOGGER.error("decision table execution failed", (Throwable)ade);
            executionContext.getRuleResults().clear();
            executionContext.getAuditContainer().setFailed();
            executionContext.getAuditContainer().setExceptionMessage(this.getExceptionMessage((Exception)((Object)ade)));
        }
        LOGGER.debug("End table evaluation: {}", (Object)decisionTable.getId());
    }

    protected boolean executeRule(DecisionRule rule, ELExecutionContext executionContext) {
        if (rule == null) {
            throw new FlowableException("rule cannot be null");
        }
        LOGGER.debug("Start rule {} evaluation", (Object)rule.getRuleNumber());
        executionContext.getAuditContainer().addRuleEntry(rule);
        boolean conditionResult = false;
        for (RuleInputClauseContainer conditionContainer : rule.getInputEntries()) {
            String inputEntryId = conditionContainer.getInputEntry().getId();
            conditionResult = false;
            try {
                String inputEntryText = conditionContainer.getInputEntry().getText();
                conditionResult = StringUtils.isEmpty((CharSequence)inputEntryText) || "-".equals(inputEntryText) ? true : this.executeInputExpressionEvaluation(conditionContainer, executionContext);
                executionContext.getAuditContainer().addInputEntry(rule.getRuleNumber(), inputEntryId, Boolean.valueOf(conditionResult));
                LOGGER.debug("input entry {} ( {} {} ): {} ", new Object[]{inputEntryId, conditionContainer.getInputClause().getInputExpression().getText(), inputEntryText, conditionResult});
            }
            catch (FlowableException ade) {
                executionContext.getAuditContainer().addInputEntry(rule.getRuleNumber(), inputEntryId, this.getExceptionMessage((Exception)((Object)ade)), null);
                throw ade;
            }
            catch (Exception e) {
                executionContext.getAuditContainer().addInputEntry(rule.getRuleNumber(), inputEntryId, this.getExceptionMessage(e), null);
                throw new FlowableException(this.getExceptionMessage(e), (Throwable)e);
            }
            if (!conditionResult) break;
            executionContext.getAuditContainer().markRuleValid(rule.getRuleNumber());
        }
        executionContext.getAuditContainer().markRuleEnd(rule.getRuleNumber());
        LOGGER.debug("End rule {} evaluation", (Object)rule.getRuleNumber());
        return conditionResult;
    }

    protected Boolean executeInputExpressionEvaluation(RuleInputClauseContainer ruleContainer, ELExecutionContext executionContext) {
        return ELExpressionExecutor.executeInputExpression(ruleContainer.getInputClause(), ruleContainer.getInputEntry(), this.expressionManager, executionContext);
    }

    protected void executeOutputEntryAction(int ruleNumber, List<RuleOutputClauseContainer> ruleOutputContainers, HitPolicy hitPolicy, ELExecutionContext executionContext) {
        LOGGER.debug("Start conclusion processing");
        for (RuleOutputClauseContainer clauseContainer : ruleOutputContainers) {
            this.composeOutputEntryResult(ruleNumber, clauseContainer, hitPolicy, executionContext);
        }
        LOGGER.debug("End conclusion processing");
    }

    protected void composeOutputEntryResult(int ruleNumber, RuleOutputClauseContainer ruleClauseContainer, HitPolicy hitPolicy, ELExecutionContext executionContext) {
        LOGGER.debug("Start evaluation conclusion {} of valid rule {}", (Object)ruleClauseContainer.getOutputClause().getOutputNumber(), (Object)ruleNumber);
        String outputVariableId = ruleClauseContainer.getOutputClause().getName();
        String outputVariableType = ruleClauseContainer.getOutputClause().getTypeRef();
        LiteralExpression outputEntryExpression = ruleClauseContainer.getOutputEntry();
        if (StringUtils.isNotEmpty((CharSequence)outputEntryExpression.getText())) {
            Object executionVariable = null;
            try {
                Object resultValue = ELExpressionExecutor.executeOutputExpression(ruleClauseContainer.getOutputClause(), outputEntryExpression, this.expressionManager, executionContext);
                executionVariable = ExecutionVariableFactory.getExecutionVariable(outputVariableType, resultValue);
                if (this.getHitPolicyBehavior(hitPolicy) instanceof ComposeRuleResultBehavior) {
                    this.getHitPolicyBehavior(hitPolicy).composeRuleResult(ruleNumber, outputVariableId, executionVariable, executionContext);
                }
                executionContext.getAuditContainer().addOutputEntry(ruleNumber, outputEntryExpression.getId(), executionVariable);
                executionContext.getAuditContainer().addDecisionResultType(outputVariableId, outputVariableType);
                if (executionVariable != null) {
                    LOGGER.debug("Created conclusion result: {} of type: {} with value {} ", new Object[]{outputVariableId, resultValue.getClass(), resultValue.toString()});
                }
                LOGGER.warn("Could not create conclusion result");
            }
            catch (FlowableException ade) {
                executionContext.getRuleResults().clear();
                executionContext.getAuditContainer().addOutputEntry(ruleNumber, outputEntryExpression.getId(), this.getExceptionMessage((Exception)((Object)ade)), executionVariable);
                throw ade;
            }
            catch (Exception e) {
                executionContext.getRuleResults().clear();
                executionContext.getAuditContainer().addOutputEntry(ruleNumber, outputEntryExpression.getId(), this.getExceptionMessage(e), executionVariable);
                throw new FlowableException(this.getExceptionMessage(e), (Throwable)e);
            }
        } else {
            LOGGER.debug("Expression is empty");
            executionContext.getAuditContainer().addOutputEntry(ruleNumber, outputEntryExpression.getId(), null);
        }
        LOGGER.debug("End evaluation conclusion {} of valid rule {}", (Object)ruleClauseContainer.getOutputClause().getOutputNumber(), (Object)ruleNumber);
    }

    protected String getExceptionMessage(Exception exception) {
        String exceptionMessage = exception.getCause() != null && exception.getCause().getMessage() != null ? exception.getCause().getMessage() : exception.getMessage();
        return exceptionMessage;
    }

    protected AbstractHitPolicy getHitPolicyBehavior(HitPolicy hitPolicy) {
        AbstractHitPolicy hitPolicyBehavior = this.hitPolicyBehaviors.get(hitPolicy.getValue());
        if (hitPolicyBehavior == null) {
            String hitPolicyBehaviorNotFoundMessage = String.format("HitPolicy behavior: %s not configured", hitPolicy.getValue());
            LOGGER.error(hitPolicyBehaviorNotFoundMessage);
            throw new FlowableException(hitPolicyBehaviorNotFoundMessage);
        }
        return hitPolicyBehavior;
    }

    protected void sanityCheckDecisionTable(DecisionTable decisionTable) {
        if (decisionTable.getHitPolicy() == HitPolicy.COLLECT && decisionTable.getAggregation() != null && decisionTable.getOutputs() != null) {
            if (decisionTable.getOutputs().size() > 1) {
                throw new FlowableException(String.format("HitPolicy: %s has aggregation: %s and multiple outputs. This is not supported", decisionTable.getHitPolicy(), decisionTable.getAggregation()));
            }
            if (!"number".equals(((OutputClause)decisionTable.getOutputs().get(0)).getTypeRef())) {
                throw new FlowableException(String.format("HitPolicy: %s has aggregation: %s needs output type number", decisionTable.getHitPolicy(), decisionTable.getAggregation()));
            }
        }
    }
}

