/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.hitpolicy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.dmn.api.RuleExecutionAuditContainer;
import org.flowable.dmn.engine.impl.context.Context;
import org.flowable.dmn.engine.impl.hitpolicy.AbstractHitPolicy;
import org.flowable.dmn.engine.impl.hitpolicy.ComposeDecisionResultBehavior;
import org.flowable.dmn.engine.impl.hitpolicy.EvaluateRuleValidityBehavior;
import org.flowable.dmn.engine.impl.mvel.MvelExecutionContext;
import org.flowable.dmn.model.HitPolicy;
import org.flowable.engine.common.api.FlowableException;

public class HitPolicyUnique
extends AbstractHitPolicy
implements EvaluateRuleValidityBehavior,
ComposeDecisionResultBehavior {
    @Override
    public String getHitPolicyName() {
        return HitPolicy.UNIQUE.getValue();
    }

    @Override
    public void evaluateRuleValidity(int ruleNumber, MvelExecutionContext executionContext) {
        for (Map.Entry entry : executionContext.getAuditContainer().getRuleExecutions().entrySet()) {
            if (((Integer)entry.getKey()).equals(ruleNumber) || !((RuleExecutionAuditContainer)entry.getValue()).isValid().booleanValue()) continue;
            String hitPolicyViolatedMessage = String.format("HitPolicy UNIQUE violated: rule %d is valid but rule %d was already valid", ruleNumber, entry.getKey());
            if (!Context.getDmnEngineConfiguration().isStrictMode()) continue;
            ((RuleExecutionAuditContainer)executionContext.getAuditContainer().getRuleExecutions().get(ruleNumber)).setExceptionMessage(hitPolicyViolatedMessage);
            throw new FlowableException("HitPolicy UNIQUE violated");
        }
    }

    @Override
    public void composeDecisionResults(MvelExecutionContext executionContext) {
        List<Map<String, Object>> decisionResult;
        ArrayList<Map<String, Object>> ruleResults = new ArrayList<Map<String, Object>>(executionContext.getRuleResults().values());
        if (!Context.getDmnEngineConfiguration().isStrictMode()) {
            HashMap lastResult = new HashMap();
            for (Map map : ruleResults) {
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() == null) continue;
                    lastResult.put(entry.getKey(), entry.getValue());
                }
            }
            decisionResult = Arrays.asList(lastResult);
        } else {
            decisionResult = ruleResults;
        }
        executionContext.setDecisionResults(decisionResult);
    }
}

