/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.cfg.standalone;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.dmn.engine.impl.cfg.TransactionContext;
import org.flowable.dmn.engine.impl.cfg.TransactionListener;
import org.flowable.dmn.engine.impl.db.DbSqlSession;
import org.flowable.dmn.engine.impl.interceptor.Command;
import org.flowable.dmn.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.engine.impl.interceptor.CommandExecutor;
import org.flowable.engine.common.impl.cfg.TransactionPropagation;
import org.flowable.engine.common.impl.cfg.TransactionState;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneMybatisTransactionContext
implements TransactionContext {
    private static Logger log = LoggerFactory.getLogger(StandaloneMybatisTransactionContext.class);
    protected CommandContext commandContext;
    protected Map<TransactionState, List<TransactionListener>> stateTransactionListeners;

    public StandaloneMybatisTransactionContext(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    @Override
    public void addTransactionListener(TransactionState transactionState, TransactionListener transactionListener) {
        List<TransactionListener> transactionListeners;
        if (this.stateTransactionListeners == null) {
            this.stateTransactionListeners = new HashMap<TransactionState, List<TransactionListener>>();
        }
        if ((transactionListeners = this.stateTransactionListeners.get(transactionState)) == null) {
            transactionListeners = new ArrayList<TransactionListener>();
            this.stateTransactionListeners.put(transactionState, transactionListeners);
        }
        transactionListeners.add(transactionListener);
    }

    @Override
    public void commit() {
        log.debug("firing event committing...");
        this.fireTransactionEvent(TransactionState.COMMITTING, false);
        log.debug("committing the ibatis sql session...");
        this.getDbSqlSession().commit();
        log.debug("firing event committed...");
        this.fireTransactionEvent(TransactionState.COMMITTED, true);
    }

    protected void fireTransactionEvent(TransactionState transactionState, boolean executeInNewContext) {
        if (this.stateTransactionListeners == null) {
            return;
        }
        final List<TransactionListener> transactionListeners = this.stateTransactionListeners.get(transactionState);
        if (transactionListeners == null) {
            return;
        }
        if (executeInNewContext) {
            CommandExecutor commandExecutor = this.commandContext.getDmnEngineConfiguration().getCommandExecutor();
            CommandConfig commandConfig = new CommandConfig(false, TransactionPropagation.REQUIRES_NEW);
            commandExecutor.execute(commandConfig, new Command<Void>(){

                @Override
                public Void execute(CommandContext commandContext) {
                    StandaloneMybatisTransactionContext.this.executeTransactionListeners(transactionListeners, commandContext);
                    return null;
                }
            });
        } else {
            this.executeTransactionListeners(transactionListeners, this.commandContext);
        }
    }

    protected void executeTransactionListeners(List<TransactionListener> transactionListeners, CommandContext commandContext) {
        for (TransactionListener transactionListener : transactionListeners) {
            transactionListener.execute(commandContext);
        }
    }

    protected DbSqlSession getDbSqlSession() {
        return this.commandContext.getDbSqlSession();
    }

    @Override
    public void rollback() {
        block10: {
            try {
                try {
                    log.debug("firing event rolling back...");
                    this.fireTransactionEvent(TransactionState.ROLLINGBACK, false);
                }
                catch (Throwable exception) {
                    try {
                        log.info("Exception during transaction: {}", (Object)exception.getMessage());
                        this.commandContext.exception(exception);
                        break block10;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        log.debug("rolling back ibatis sql session...");
                        this.getDbSqlSession().rollback();
                    }
                }
                log.debug("rolling back ibatis sql session...");
                this.getDbSqlSession().rollback();
            }
            catch (Throwable exception) {
                log.info("Exception during transaction: {}", (Object)exception.getMessage());
                this.commandContext.exception(exception);
            }
            finally {
                log.debug("firing event rolled back...");
                this.fireTransactionEvent(TransactionState.ROLLED_BACK, true);
            }
        }
    }
}

