/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.dmn.api.DmnDecisionTable;
import org.flowable.dmn.engine.impl.persistence.deploy.DecisionTableCacheEntry;
import org.flowable.dmn.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.flowable.dmn.model.Decision;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;

public abstract class AbstractExecuteDecisionCmd
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String decisionKey;
    protected String parentDeploymentId;
    protected Map<String, Object> variables;
    protected String tenantId;

    protected DmnDecisionTable resolveDecisionTable(DeploymentManager deploymentManager) {
        DecisionTableEntity decisionTable = null;
        if (StringUtils.isNotEmpty((CharSequence)this.decisionKey) && StringUtils.isNotEmpty((CharSequence)this.parentDeploymentId) && StringUtils.isNotEmpty((CharSequence)this.tenantId)) {
            decisionTable = deploymentManager.findDeployedLatestDecisionByKeyParentDeploymentIdAndTenantId(this.decisionKey, this.parentDeploymentId, this.tenantId);
            if (decisionTable == null) {
                throw new FlowableObjectNotFoundException("No decision found for key: " + this.decisionKey + ", parent deployment id " + this.parentDeploymentId + " and tenant id: " + this.tenantId);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)this.decisionKey) && StringUtils.isNotEmpty((CharSequence)this.parentDeploymentId)) {
            decisionTable = deploymentManager.findDeployedLatestDecisionByKeyAndParentDeploymentId(this.decisionKey, this.parentDeploymentId);
            if (decisionTable == null) {
                throw new FlowableObjectNotFoundException("No decision found for key: " + this.decisionKey + " and parent deployment id " + this.parentDeploymentId);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)this.decisionKey) && StringUtils.isNotEmpty((CharSequence)this.tenantId)) {
            decisionTable = deploymentManager.findDeployedLatestDecisionByKeyAndTenantId(this.decisionKey, this.tenantId);
            if (decisionTable == null) {
                throw new FlowableObjectNotFoundException("No decision found for key: " + this.decisionKey + " and tenant id " + this.tenantId);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)this.decisionKey)) {
            decisionTable = deploymentManager.findDeployedLatestDecisionByKey(this.decisionKey);
            if (decisionTable == null) {
                throw new FlowableObjectNotFoundException("No decision found for key: " + this.decisionKey);
            }
        } else {
            throw new IllegalArgumentException("decisionKey is null");
        }
        return decisionTable;
    }

    protected Decision resolveDecision(DeploymentManager deploymentManager, DmnDecisionTable decisionTable) {
        if (decisionTable == null) {
            throw new IllegalArgumentException("decisionTable is null");
        }
        DecisionTableCacheEntry decisionTableCacheEntry = deploymentManager.resolveDecisionTable(decisionTable);
        Decision decision = decisionTableCacheEntry.getDecision();
        return decision;
    }
}

