/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.mvel;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.dmn.api.DecisionExecutionAuditContainer;
import org.flowable.engine.common.api.FlowableException;
import org.mvel2.ParserContext;
import org.mvel2.integration.PropertyHandler;

public class MvelExecutionContext {
    protected Map<String, Object> resultVariables = new HashMap<String, Object>();
    protected Map<String, Object> stackVariables;
    protected ParserContext parserContext;
    protected Map<Class<?>, PropertyHandler> propertyHandlers = new HashMap();
    protected DecisionExecutionAuditContainer auditContainer;

    public void checkExecutionContext(String variableId) {
        if (StringUtils.isEmpty((CharSequence)variableId)) {
            throw new IllegalArgumentException("Variable id cannot be empty");
        }
        if (this.stackVariables == null || this.stackVariables.isEmpty()) {
            throw new IllegalArgumentException("Variables cannot be empty when variable id: " + variableId + " is used");
        }
        if (variableId.contains(".")) {
            String rootVariableId = variableId.substring(0, variableId.indexOf("."));
            if (!this.stackVariables.containsKey(rootVariableId)) {
                throw new FlowableException("referred id: " + rootVariableId + " is not present on the context");
            }
        } else if (!this.stackVariables.containsKey(variableId)) {
            throw new FlowableException("referred id: " + variableId + " is not present on the context");
        }
    }

    public void addResultVariable(String key, Object value) {
        this.resultVariables.put(key, value);
    }

    public void setStackVariables(Map<String, Object> variables) {
        this.stackVariables = variables;
    }

    public Map<String, Object> getStackVariables() {
        return this.stackVariables;
    }

    public Map<String, Object> getResultVariables() {
        return this.resultVariables;
    }

    public ParserContext getParserContext() {
        return this.parserContext;
    }

    public void setParserContext(ParserContext parserContext) {
        this.parserContext = parserContext;
    }

    public Map<Class<?>, PropertyHandler> getPropertyHandlers() {
        return this.propertyHandlers;
    }

    public void addPropertyHandler(Class<?> variableClass, PropertyHandler propertyHandler) {
        this.propertyHandlers.put(variableClass, propertyHandler);
    }

    public DecisionExecutionAuditContainer getAuditContainer() {
        return this.auditContainer;
    }

    public void setAuditContainer(DecisionExecutionAuditContainer auditContainer) {
        this.auditContainer = auditContainer;
    }
}

